<?php
  
use Illuminate\Support\Facades\Route;
  
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ListController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\MiscellaneousController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\CustomFieldController;
use App\Http\Controllers\SuppressionController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\BroadcastController;
use App\Http\Controllers\TemplateController;
use App\Http\Controllers\SpintagController;
use App\Http\Controllers\BounceController;
use App\Http\Controllers\FblController;
use App\Http\Controllers\TrackingDomainController;
use App\Http\Controllers\SendingDomainController;
use App\Http\Controllers\EmailPageController;
use App\Http\Controllers\SendingServerController;
use App\Http\Controllers\ScheduleCampaignController;
use App\Http\Controllers\ScheduleCampaignStatController;
use App\Http\Controllers\TrackingController;
use App\Http\Controllers\BlacklistController;
use App\Http\Controllers\ToolController;
use App\Http\Controllers\CallbackController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\SegmentationController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\TriggerController;
use App\Http\Controllers\TriggerScheduleStatController;

Route::get("/clear_cache", function () {
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('config:cache');
    Artisan::call('view:clear');
    return response()->json(['success' => true, 'msg' => 'Cache has been cleared'], 200);
});

// custom reset password notification
Auth::routes(['reset' => true]);   
Auth::routes();

Route::group(['middleware' => ['auth','language']], function() {
    Route::get('/', [DashboardController::class, 'index']);
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/campaigns/sent/{type?}', [DashboardController::class, 'getSentData'])->name('campaigns.sent.data');

    // impersonate user
    Route::post('/impersonate/{id}', function($id){
        Auth::loginUsingId($id);
        if($id == config('custom.app_id')) 
            Session::forget('impersonate');
        else
            session(['impersonate' => true]);
        return redirect()->route('dashboard');
    })->name('user.impersonate');

    Route::resource('roles', RoleController::class)->except(['show']);
    Route::get('/get_roles', [RoleController::class, 'getRoles'])->name('roles');
    Route::resource('users', UserController::class)->except(['show']);
    Route::get('/get_users', [UserController::class, 'getUsers'])->name('users');
    Route::get('/profile', [UserController::class, 'profile'])->name('profile');
    Route::get('/settings', [SettingController::class, 'index'])->name('settings');
    Route::put('/settings/{id}', [SettingController::class, 'update'])->name('settings.update');

    Route::any('/api', [SettingController::class, 'api'])->name('api');
    Route::put('/api-status', [SettingController::class, 'apiStatus'])->name('api.status');

    // Mis
    Route::get('/activity_logs', [MiscellaneousController::class, 'activityLogs'])->name('activity.logs');
    Route::get('/get_activity_logs', [MiscellaneousController::class, 'getActivityLogs'])->name('activitylogs');
    Route::get('/error_logs', [MiscellaneousController::class, 'errorLogs'])->name('error.logs');
    Route::get('/get_error_logs', [\Rap2hpoutre\LaravelLogViewer\LogViewerController::class, 'index']);
    Route::get('/php_info', [MiscellaneousController::class, 'phpInfo'])->name('php.info');
    Route::get('/get_php_info', function () {
        phpinfo();
    });

    Route::get('/update', [ToolController::class, 'update'])->name('update');
    Route::post('/update_app', [ToolController::class, 'updateApp'])->name('update.app');

    Route::get('/help', function() {
        return view('includes.help');
    })->name('help');
    Route::post('/help_send', [ToolController::class, 'helpSend']);

    Route::get('/image_manager', function() {
        \App\Http\Helper\Helper::checkPermissions('image_manager');
        $page = 'tools_image_manager';
        $page_title = __('app.image_manager');
        $breadcrumbs = [__('app.miscellaneous') => route('activity.logs'),__('app.image_manager') => '#'];
        return view('miscellaneous.image_manager',compact('page', 'page_title', 'breadcrumbs'));
    })->name('image.manager');

    // Lists
    Route::resource('lists', ListController::class);
    Route::get('/get_lists', [ListController::class, 'getLists'])->name('get.lists');
    Route::get('/list/copy/{id}', [ListController::class, 'copy'])->name('list.copy');
    Route::any('/list_split/{id?}', [ListController::class, 'split'])->name('list.split');
    Route::post('/list_empty/{id}', [ListController::class, 'empty'])->name('list.empty');
    Route::any('/list/bulk_update', [ListController::class, 'bulkUpdate'])->name('bulk.update');

    // Groups
    Route::resource('groups', GroupController::class)->except(['show']);
    Route::get('/group_create/{type_id?}', [GroupController::class, 'create'])->name('group.create');
    Route::get('/get_group_lists/{type_id?}', [GroupController::class, 'getGroupLists'])->name('get.group.lists');
    Route::delete('/group-delete/{model}', [GroupController::class, 'deleteGroup'])->name('group.delete');


    // Custom Fields
    Route::resource('custom_fields', CustomFieldController::class)->except(['show']);
    Route::get('/get_custom_fields', [CustomFieldController::class, 'getCustomFields'])->name('get.custom_fields');
    Route::get('/custom_field_create', [CustomFieldController::class, 'create'])->name('custom_field.create');


    // Contacts
    Route::resource('contacts', ContactController::class);
    Route::get('/get_contacts', [ContactController::class, 'getContacts'])->name('get.contacts');
    Route::get('/lists-custom-fields', [ContactController::class, 'getListsCustomFields'])->name('list.custom_fields');
    Route::any('/contacts-export/{id}/{data?}', [ContactController::class, 'contactsExport'])->name('contacts.export');
    Route::any('/contacts-import/{id?}', [ContactController::class, 'contactsImport'])->name('contacts.import');
    Route::get('/contacts-import-status/{id}', [ContactController::class, 'contactsImportStatus']);


    // Suppression
    Route::resource('suppressions', SuppressionController::class)->except(['show','edit', 'update']);
    Route::get('/get_suppression', [SuppressionController::class, 'getSuppressions'])->name('get.suppressions');
    Route::post('/suppression/import', [SuppressionController::class, 'suppressionImport'])->name('suppression.import');
    Route::get('/suppression/export', [SuppressionController::class, 'suppressionExport'])->name('suppression.export');

    // Notifications
    Route::get('/notification/read/{id}', [NotificationController::class, 'read'])->name('notification.read');
    Route::get('/notification/read_all', [NotificationController::class, 'readAll'])->name('notification.read.all');

    // Broadcasts
    Route::resource('broadcasts', BroadcastController::class);
    Route::get('/get_broadcasts', [BroadcastController::class, 'getBroadcasts'])->name('broadcasts');
    Route::get('/broadcast/copy/{id}', [BroadcastController::class, 'copy'])->name('broadcast.copy');
    Route::any('/broadcast/mail-headers',  [BroadcastController::class, 'mailHeaders'])->name('broadcast.mail.headers');
    Route::get('/broadcast/detail/{id}',  [BroadcastController::class, 'getBoradcastDetail'])->name('broadcast.detail');
    Route::get('/broadcasts-all', function() {
        return view('broadcasts.all');
    })->name('broadcasts.all');
    Route::get('/broadcast/html/{id}', [BroadcastController::class, 'getHTMLContent']);

    // Templates
    Route::resource('templates', TemplateController::class)->except(['update']);;
    Route::get('/get_templates', [TemplateController::class, 'getTemplates'])->name('get.templates');
    Route::get('/get_builder', [TemplateController::class, 'getBuilder'])->name('get.builder');
    Route::post('/template_save', [TemplateController::class, 'store'])->name('template.save');
    Route::get('/template/html/{id}', [TemplateController::class, 'getHTMLContent']);
    Route::get('/templates-all', function() {
        return view('templates.all');
    })->name('templates.all');

    // Spintag
    Route::resource('spintags', SpintagController::class)->except(['show']);;
    Route::get('/get_spintags', [SpintagController::class, 'getSpintags'])->name('get.spintags');

    // Bounce Servers
    Route::resource('bounces', BounceController::class)->except(['show']);
    Route::get('/get_bounces', [BounceController::class, 'getBounces'])->name('get.bounces');
    Route::get('/validate_bounce_imap', [BounceController::class, 'validateImap'])->name('validateBounceImap');
    Route::get('/bounce/copy/{id}', [BounceController::class, 'copy'])->name('bounce.copy');

    // Feedback Loop Servers
    Route::resource('fbls', FblController::class)->except(['show']);
    Route::get('/get_fbls', [FblController::class, 'getfbls'])->name('get.fbls');
    Route::get('/validate_fbl_imap', [BounceController::class, 'validateImap'])->name('validateFblImap');
    Route::get('/fbl/copy/{id}', [FblController::class, 'copy'])->name('fbl.copy');

    // Sending Domains
    Route::resource('sending_domains', SendingDomainController::class)->except(['edit']);
    Route::get('/get_sending_domains', [SendingDomainController::class, 'getSendingDomains'])->name('get.sending_domains');
    Route::get('/download_keys/{id}', [SendingDomainController::class, 'downloadKeys'])->name('download.keys');
    Route::get('/domain_verfications/{id}/{type}', [SendingDomainController::class, 'domainVerifications'])->name('domain.verifications');

    // Tracking Domains
    Route::resource('tracking_domains', TrackingDomainController::class)->except(['show']);
    Route::get('/get_tracking_domains', [TrackingDomainController::class, 'getTrackingDomains'])->name('get.tracking_domains');

    // EmailsPages
    Route::resource('contents', EmailPageController::class);
    Route::get('/get_emails_pages', [EmailPageController::class, 'getEmailsPages'])->name('get.emails_pages');

    // Sending Servers
    Route::resource('sending_servers', SendingServerController::class);
    Route::get('/get_sending_servers', [SendingServerController::class, 'getSendingServers'])->name('get.sending_servers');
    Route::get('/get_sending_server_fields/{type}/{action}/{id?}', [SendingServerController::class, 'getSendingServerFields']);
    Route::get('/sending_server/copy/{id}', [SendingServerController::class, 'copy'])->name('sending_server.copy');
    Route::put('/sending_server/reset_counter/{id}', [SendingServerController::class, 'resetCounter'])->name('sent.clear');
    Route::get('/sending_server/status/{id}', function($id){
        return view('sending_servers.status')->with('id', $id);
    })->name('sending_server.status');
    Route::get('/callback_help/{type}', function($type){
        return view('sending_servers.callback_help')->with('type', $type);
    })->name('callback.help');
    Route::get('/send_email/{broadcast_id}/{sending_server_id}/{template_id}/{display_name?}', function($broadcast_id, $sending_server_id, $template_id, $display_name=null){
        return view('includes.send_test_email')->with(compact('broadcast_id', 'sending_server_id', 'template_id', 'display_name'));
    })->name('send.email');
    Route::post('/send_email_test', [SendingServerController::class, 'sendEmailTest']);

    // get shortcodes
    Route::get('/shortcodes/{section?}', function($section='all'){
        return \App\Http\Helper\Helper::shortcodes($section);
    })->name('shortcodes');

    // schedules campaigns
    Route::resource('schedule_campaigns', ScheduleCampaignController::class);
    Route::get('/get_schedule_campaigns', [ScheduleCampaignController::class, 'getScheduleCampaigns'])->name('get.schedule_campaigns');
    Route::get('/get_scheduled_detail_stat_campaign/{id}/{type?}', [ScheduleCampaignController::class, 'getScheduledDetail'])->name('scheduled.detail.campaign');
    Route::get('/copy_schedule/{id}', [ScheduleCampaignController::class, 'copy'])->name('copy.schedule');
    Route::get('/schedule_campaign/html/{id}', [ScheduleCampaignController::class, 'getHTMLContent'])->name('get.schedule_campaign.content');
    Route::put('/limited_to_unlimited', [ScheduleCampaignController::class, 'limitedToUnlimited'])->name('limited.to.unlimited');
    Route::put('/set_2x_speed', [ScheduleCampaignController::class, 'set2xSpeed'])->name('set.2x.speed');
    Route::put('/update_schedule_campaign_status/{id}', [ScheduleCampaignController::class, 'updateScheduleStatus']);
    Route::get('/shceduled_events', [ScheduleCampaignController::class, 'scheduledEvents']);

    // Analatics Campaigns
    Route::get('/stats/campaigns', [ScheduleCampaignStatController::class, 'index'])->name('stats.campaigns.index');
    Route::get('/get_stats_campaigns', [ScheduleCampaignStatController::class, 'getStatsCampaigns'])->name('stats.campaigns');
    Route::get('/stat/export/{id}', [ScheduleCampaignStatController::class, 'export'])->name('stat.campaign.export');
    Route::get('/stat/export/download/{id}', [ScheduleCampaignStatController::class, 'exportDownload'])->name('stat.campaign.export.download');
    Route::get('/detail/stat/campaign/{id?}/{type?}/{view?}', [ScheduleCampaignStatController::class, 'getDetailStat'])->name('detail.stat.campaign');
    Route::get('/campaign/opens', [ScheduleCampaignStatController::class, 'getOpens'])->name('campaign.opens');
    Route::get('/campaign/clicks', [ScheduleCampaignStatController::class, 'getClicks'])->name('campaign.clicks');
    Route::get('/campaign/unsubscribed', [ScheduleCampaignStatController::class, 'getUnsubscribed'])->name('campaign.unsubscribed');
    Route::get('/campaign/bounces', [ScheduleCampaignStatController::class, 'getBounces'])->name('campaign.bounces');
    Route::get('/campaign/spam', [ScheduleCampaignStatController::class, 'getSpam'])->name('campaign.spam');
    Route::get('/campaign/logs', [ScheduleCampaignStatController::class, 'getLogs'])->name('campaign.logs');
    Route::get('/campaign/sent/{id}/{type?}', [ScheduleCampaignStatController::class, 'getSentData'])->name('campaign.sent.data');
    Route::delete('/stat/destroy/{id}/{name}', [ScheduleCampaignStatController::class, 'destroy'])->name('stat.campaign.destroy');
    Route::get('/stat/export/{id}', [ScheduleCampaignStatController::class, 'export'])->name('stat.campaign.export');
    Route::get('/stat/export/download/{id}', [ScheduleCampaignStatController::class, 'exportDownload'])->name('stat.campaign.export.download');

    // Blacklist Controller
    Route::get('/system_bounced', [BlacklistController::class, 'systemBounced'])->name('system.bounced');
    Route::get('/get_system_bounced', [BlacklistController::class, 'getSystemBounced'])->name('get.system.bounced');
    Route::delete('/system_bounced/{id}', [BlacklistController::class, 'destroySystemBounced'])->name('system.bounced.destroy');
    Route::any('/global/bounced/import', [BlacklistController::class, 'importSystemBounced'])->name('system.bounced.import');
    Route::get('/global/bounced/export', [BlacklistController::class, 'exportBounced'])->name('system.bounced.export');

    // Segmentation
    Route::resource('list_segmentations', SegmentationController::class);
    Route::get('get_list_segmentations', [SegmentationController::class, 'getSegmentations'])->name('get.list.segmentations');
    Route::get('/segment/action/{id}/{action}', [SegmentationController::class, 'action'])->name('segment.action');
    Route::put('/segment/action/{id}', [SegmentationController::class, 'action'])->name('segment.update.action');


    // Clients Controller
    Route::resource('clients', ClientController::class);
    Route::get('/get_clients', [ClientController::class, 'getClients'])->name('get.clients');

    // Packages Controller
    Route::resource('packages', PackageController::class)->except(['show']);
    Route::get('/get_packages', [PackageController::class, 'getPackages'])->name('get.packages');

    // Trigger Controller
    Route::resource('triggers', TriggerController::class)->except(['show']);
    Route::get('/get_triggers', [TriggerController::class, 'getTriggers'])->name('get.triggers');
    Route::get('/get_based_on_data/{type}/{action}/{id?}', [TriggerController::class, 'getBasedOnData']);

    // Analatics Triggers
    Route::get('/stats/triggers', [TriggerScheduleStatController::class, 'index'])->name('stats.triggers.index');
    Route::get('/get_stats_triggers', [TriggerScheduleStatController::class, 'getStatsTriggers'])->name('stats.triggers');
    Route::get('/stat/trigger/export/{id}', [TriggerScheduleStatController::class, 'export'])->name('stat.trigger.export');
    Route::get('/stat/trigger/export/download/{id}', [TriggerScheduleStatController::class, 'exportDownload'])->name('stat.trigger.export.download');
    Route::get('/detail/stat/trigger/{id?}/{type?}/{view?}', [TriggerScheduleStatController::class, 'getDetailStat'])->name('detail.stat.trigger');
    Route::get('/trigger/opens', [TriggerScheduleStatController::class, 'getOpens'])->name('trigger.opens');
    Route::get('/trigger/clicks', [TriggerScheduleStatController::class, 'getClicks'])->name('trigger.clicks');
    Route::get('/trigger/unsubscribed', [TriggerScheduleStatController::class, 'getUnsubscribed'])->name('trigger.unsubscribed');
    Route::get('/trigger/bounces', [TriggerScheduleStatController::class, 'getBounces'])->name('trigger.bounces');
    Route::get('/trigger/spam', [TriggerScheduleStatController::class, 'getSpam'])->name('trigger.spam');
    Route::get('/trigger/logs', [TriggerScheduleStatController::class, 'getLogs'])->name('trigger.logs');
    Route::get('/trigger/sent/{id}/{type?}', [TriggerScheduleStatController::class, 'getSentData'])->name('trigger.sent.data');
    Route::delete('/stat/trigger/destroy/{id}/{name}', [TriggerScheduleStatController::class, 'destroy'])->name('stat.trigger.destroy');
    Route::get('/stat/trigger/export/{id}', [TriggerScheduleStatController::class, 'export'])->name('stat.trigger.export');
    Route::get('/stat/trigger/export/download/{id}', [TriggerScheduleStatController::class, 'exportDownload'])->name('stat.trigger.export.download');
    Route::get('/trigger/html/{id}', [TriggerScheduleStatController::class, 'getHTMLContent'])->name('get.trigger_schedule.content');

});

// No authenticate
Route::group(['middleware' => ['language']], function() {
    Route::get('/run_campaigns/{id?}/{thread_no?}', [ScheduleCampaignController::class, 'runCampaigns']);
    Route::get('/contact/unsub/{contact_id}/{stat_log_id?}', [ContactController::class, 'unsub'])->name('contact.unsub');
    Route::get('/contact/do-unsub/{id}/{stat_log_id?}', [ContactController::class, 'doUnsub'])->name('contact.do.unsub');
    Route::get('/page/{slug}/{contact_id?}/{stat_log_id?}', [EmailPageController::class, 'showPage'])->name('page.show');
});

// No middleware
Route::get('/ok', function(){
  return response()->json(['success' => 'success'], 200);
});


// Campaign
Route::get('/open/{id}', [TrackingController::class, 'openSchedule']);
Route::get('/click/{id}/{url}', [TrackingController::class, 'clickSchedule']);

// Triggers
Route::get('/ts/open/{id}', [TrackingController::class, 'openTriggerSchedule']);
Route::get('/ts/click/{id}/{url}', [TrackingController::class, 'clickTriggerSchedule']);

// Installation
Route::post('/installation', [InstallController::class, 'installation']);


// Callbacks
Route::prefix('callback')->group(function () {
  // any to return success
  Route::any('amazon', [CallbackController::class, 'amazon']);
  Route::any('mailgun', [CallbackController::class, 'mailgun']);
  Route::any('sendgrid', [CallbackController::class, 'sendgrid']);
  Route::any('sparkpost', [CallbackController::class, 'sparkpost']);
});
