<script src="{{asset('assets/js/app.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('suppressions.store')}}" enctype="multipart/form-data" class="needs-validation" novalidate>
        @csrf
        <div class="modal-header">
          <h6 class="modal-title" id="staticBackdropLabel">{{__('app.add_suppression')}}
          </h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <div class="box-body">
            <div class="col-md-12">
             <label class="form-label">{{__('app.group')}}
              <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_suppression')])}}');">
               <i class="bi bi-plus-circle text-success"></i>
             </a>
           </label>
            <select name="group_id" class="single-select form-select" id="group_id" required>
             <option value="">{{__('app.select_group')}}</option> 
             @foreach($groups as $id => $group_name)
              <option value="{{ $id }}">{{$group_name}}</option>
             @endforeach
           </select>
           <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
          </div>
          <div class="col-md-12 pt-3">
            <label class="form-label">{{__('app.resource')}}</label>
            <select name="resource" id="resource" class="form-select form-select-lg">
               <option value="emails">{{ __('app.email_addresses')}}</option>
               <option value="file">{{ __('app.file') }}</option>
            </select>
         </div>
         <div class="col-md-12 pt-3" id="section-emails">
            <label class="form-label">{{__('app.email_addresses')}}</label>
            <textarea class="form-control" name="emails" rows="7" placeholder="{{ __('app.multiple_emails_placeholder') }}"></textarea>
         </div>
         <div class="col-md-12 pt-3" id="section-file" style="display: none;" >
            <label class="form-label">{{__('app.file')}}</label>
            <input class="form-control" name="file" type="file" id="file">
         </div>
         <div class="col-md-12 pt-2" id="info-filesize" style="display: none;" >
            <label class="form-label">{!! \App\Http\Helper\Helper::getMaxFileSize(false, true) !!}</label>
         </div>

         <div class="col-md-12 pt-2" id="fields-mapping" style="display: none;" >
            <label class="form-label"><h6 class="mb-3">{{ __('app.fields_mapping') }}</h6></label>
            <div class="box-body" id="suppression-fields"></div>
         </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
          <button type="submit" class="btn btn-primary btn-loading" id="btn-save"><i class=""></i> {{__('app.save')}}</button>
          <button type="button" class="btn btn-primary btn-loading" id="btn-proceed" style="display:none" onclick="suppressionImport(this, this.form, '{{ route('suppression.import') }}');"><i class=""></i> {{__('app.proceed')}}</button>
          <button type="button" class="btn btn-primary btn-loading" id="btn-import" style="display:none" onclick="doSuppressionImport(this, this.form, '{{ route('suppression.import') }}');"><i class=""></i> {{__('app.import')}}</button>
        </div>
      </form>
    </div>
</div>