@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form id="frm-api" action="{{ route('api') }}" method="post" class="row g-3 mt-0">
         @csrf
         @method('PUT')
            <div class="col-md-6 mt-1">
               <label class="form-label">{{__('app.status')}}</label>
               <select class="form-select form-select-lg" name="api_enabled" id="api-status">
                  <option value="1" {{ $user->api_enabled ? 'selected' : ''}}>{{__('app.active')}}</option>
                  <option value="0" {{ !$user->api_enabled ? 'selected' : ''}}>{{__('app.in_active')}}</option>
               </select>
            </div>
            <div class="col-md-6 mt-1">
               <label class="form-label">{{__('app.api_base_url')}}</label>
               <div class="input-group">
                  <input type="text" class="form-control" value="{{ \App\Http\Helper\Helper::getAppURL() }}/api/v1" id="api-base-url" readonly="readonly">
                  <div class="input-group-text">
                     <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary" id="copy-api-url"></i></a>
                  </div>
               </div>
            </div>
            <div class="col-md-12 mt-3">
               <label class="form-label">{{__('app.api_key')}}</label>
               <div class="input-group">
                  <input type="text" class="form-control" name="api_key" id="api-key" value="{{ $user->api_token }}" readonly="readonly">
                  <div class="input-group-text">
                     <a href="javascript:;" tabindex="-1"><i class="bi bi-copy text-primary" id="copy-api-key"></i></a>
                  </div>
                  <div class="input-group-text">
                     <a href="javascript:;" tabindex="-1"><i class="bi bi-bootstrap-reboot text-primary" id="regenerate-api-key"></i></a>
                  </div>
               </div>
            </div>
            <div class="col-md-12 mt-3">
               {!!__('app.api_documentaion_url')!!}
            </div>
      </form>
   </div>
</div>
<span id="api_msg_regenerate" data-value="{{__('app.api_msg_regenerate')}}"></span>
@endsection
