@extends('layouts.app')
@section('title', $page_title)

@section('styles')

@endsection

@push('scripts')
<script src="{{asset('components/jquery-repeater/jquery.repeater.min.js')}}"></script>
<script src="{{asset('assets/js/app.js')}}"></script>
<script src="{{asset('assets/js/segmentation.js')}}"></script>
@endpush

@php $attributes = json_decode($segment->attributes) @endphp
@section('content')
<form method="post" action="{{route('list_segmentations.update', $segment->id)}}" class="row g-3 mt-0 needs-validation" novalidate>
	@csrf
	@method('PUT')
	<div class="card custom-card">
		<div class="card-body">
			<div class="box-body">
				<label class="form-label">{{__('app.name')}}</label>
				<input type="text" class="form-control" placeholder="{{__('app.name')}}" id="name" name="name" value="{{ $segment->name }}" required>
				<div class="col-md-12 mt-3">
					<label class="form-label">{{__('app.lists')}}
						<a href="{{route('lists.create')}}" tabindex="-1">
							<i class="bi bi-plus-circle-fill text-primary"></i>
						</a>
					</label>
					@php $list_ids = $attributes->list_ids  @endphp
          @include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1, 'required' => 1])
					<div class="row">
						<div class="col-md-6">
			        <label class="form-label">{{__('app.allow_unsub')}}</label>
			        <select name="allow_unsub" class="form-select form-select-lg">
			        	<option value="Yes" {{ !empty($attributes->allow_unsub) && $attributes->allow_unsub == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
			          <option value="No" {{ !empty($attributes->allow_unsub) && $attributes->allow_unsub == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>			          
			        </select>
			      </div>
			      <div class="col-md-6">
			        <label class="form-label">{{__('app.allow_bounced')}}</label>
			        <select name="allow_bounced" class="form-select form-select-lg">
			        	<option value="Yes" {{ !empty($attributes->allow_bounced) && $attributes->allow_bounced == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
			          <option value="No" {{ !empty($attributes->allow_bounced) && $attributes->allow_bounced == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>			          
			        </select>
			      </div>
		    	</div>
				</div>
			</div>
		</div>
	</div>
	<div class="card custom-card">
		<div class="card-body">
			<div class="card-title"><h6>{{ __('app.contact_filters') }}</h6></div>
			<div class="box-body">
				<div class="box-body repeater-contact">
					<div data-repeater-list="contact_filter">
						@php $contact_filter = $attributes->contact_filter @endphp
       	 		@foreach($contact_filter as $filter)
							<div data-repeater-item class="row mt-3">
								<div class="col-md-4">
									<span data-repeater-delete>AND</span>
									<select name="name" class="form-select" onchange="loadContactAction(this);">
										<option value=""></option>
										<option value="email" {{ $filter->name == 'email' ? 'selected' : '' }}>{{ __('app.email') }}</option>
										<option value="status" {{ $filter->name == 'status' ? 'selected' : '' }}>{{ __('app.status') }}</option>
										<option value="source" {{ $filter->name == 'source' ? 'selected' : '' }}>{{ __('app.source') }}</option>
									</select>
								</div>
								<div class="col-md-3">
									<span data-repeater-delete>&nbsp;</span>
									<select name="action" class="form-select">
										<option value='is' {{ !empty($filter->action) &&  $filter->action == 'is' ? 'selected' : '' }}>is</option>
	                  <option value='is_not' {{ !empty($filter->action) &&  $filter->action == 'is_not' ? 'selected' : '' }}>is not</option>
	                  @if($filter->name == 'email')
	                  <option value='contain' {{ !empty($filter->action) && $filter->action == 'contain' ? 'selected' : '' }}>contain</option>
	                  <option value='not_contain' {{ !empty($filter->action) && $filter->action == 'not_contain' ? 'selected' : '' }}>doesn't</option>
	                  @endif
									</select>
								</div>
								<div class="col-md-4">
									<span data-repeater-delete>&nbsp;</span>
									@if($filter->name == 'email')
	                  <input type='text' class='form-control' placeholder='Use comma for multiples' name='value' value="{{ $filter->value }}">
	                @else
	                  <select name="value" class="form-select">
	                    @if($filter->name == 'status')
	                      <option value='active' {{ $filter->value == 'is_not' ? 'selected' : '' }}>Active</option>
	                      <option value='inactive' {{ $filter->value == 'is_not' ? 'selected' : '' }}>Inactive</option>
	                    @endif
	                  </select>
                	@endif
								</div>
								<div class="col-md-1" style="margin:inherit;">
								<span data-repeater-delete>&nbsp;</span>
									<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
								</div>
							</div>
						@endforeach
					</div>
					<div class="col-12 mt-2">
						<input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="card custom-card">
		<div class="card-body">
			<div class="box-body">
				<div class="card-title"><h6>{{ __('app.custom_fields_filters') }}</h6></div>
				<div class="box-body repeater-contact">
					@php $custom_fields_filter = $attributes->custom_fields_filter @endphp
					@foreach($custom_fields_filter as $filter)
						<div data-repeater-list="custom_fields_filter">
							<div data-repeater-item class="row mt-3">
								<div class="col-md-4">
									<span data-repeater-delete>AND</span>
									<select name="name" class="form-select">
			                <option value=""></option>
			                @if(!empty($custom_fields))
			                  @foreach($custom_fields as $custom_field)
			                    <option value="{{ $custom_field->id }}" {{ $filter->name == $custom_field->id ? 'selected' : '' }}>{{ $custom_field->name }}</option>
			                  @endforeach
			                @endif
		              </select>
								</div>
								<div class="col-md-3">
									<span data-repeater-delete>&nbsp;</span>
									<select name="action" class="form-select">
		                <option value=""></option>
		                <option value="is" {{ $filter->action == 'is' ? 'selected' : '' }}>is</option>
		                <option value="is_not" {{ $filter->action == 'is_not' ? 'selected' : '' }}>is not</option>
		                <option value="contain" {{ $filter->action == 'contain' ? 'selected' : '' }}>contain</option>
		                <option value="not_contain" {{ $filter->action == 'not_contain' ? 'selected' : '' }}>doesn't</option>
	              	</select>
								</div>
								<div class="col-md-4">
									<span data-repeater-delete>&nbsp;</span>
									<input type="text" name="value" class="form-control" placeholder="Use comma for multiples" value="{{ $filter->value }}">
								</div>
								<div class="col-md-1" style="margin:inherit;">
									<span data-repeater-delete>&nbsp;</span>
									<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
								</div>
							</div>
						</div>
					@endforeach
					<div class="col-12 mt-2">
						<input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="card custom-card">
		<div class="card-body">
			<div class="box-body">
				<div class="box-body repeater-contact">
					<div data-repeater-list="dates_filter">
						<div class="card-title"><h6>{{ __('app.date_filters') }}</h6></div>
						@php $dates_filter = $attributes->dates_filter @endphp
          	@foreach($dates_filter as $filter)
							<div data-repeater-item class="row mt-3">
								<div class="col-md-4">
									<span data-repeater-delete>AND</span>
									<select name="name" class="form-select">
			                <option value=""></option>
			                <option value="subscription_date" {{ $filter->name == 'subscription_date' ? 'selected' : '' }}>Subscription Date</option>
			                @if(!empty($custom_fields))
			                  @foreach($custom_fields_date as $custom_field)
			                    <option value="{{ $custom_field->id }}" {{ $filter->name == $custom_field->id ? 'selected' : '' }}>{{ $custom_field->name }}</option>
			                  @endforeach
			                @endif
		              </select>
								</div>
								<div class="col-md-3">
									<span data-repeater-delete>&nbsp;</span>
									<select name="action" class="form-select" onchange="loadDate(this)">
		                <option value=""></option>
		                <option value="is" {{ $filter->action == 'is' ? 'selected' : '' }}>is</option>
		                <option value="is_not" {{ $filter->action == 'is_not' ? 'selected' : '' }}>is not</option>
		                <option value="after" {{ $filter->action == 'after' ? 'selected' : '' }}>after</option>
		                <option value="before" {{ $filter->action == 'before' ? 'selected' : '' }}>before</option>
	              	</select>
								</div>
								<div class="col-md-4">
									<span data-repeater-delete>&nbsp;</span>
									<input type="text" name="value" class="form-control" value="{{ $filter->value }}" id="datetime">
								</div>
								<div class="col-md-1" style="margin:inherit;">
									<span data-repeater-delete>&nbsp;</span>
									<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
								</div>
							</div>
						@endforeach
					</div>
					<div class="col-12 mt-2">
						<input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-12 mt-5">
		<button type="submit" name="save"class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
		<a href="{{route('list_segmentations.index')}}">
			<button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
		</a>
	</div>
</form>
@endsection
