@extends('layouts.app')
@section('title', $page_title)

@section('styles')

@endsection

@push('scripts')
<script src="{{asset('components/jquery-repeater/jquery.repeater.min.js')}}"></script>
<script src="{{asset('assets/js/app.js')}}"></script>
<script src="{{asset('assets/js/segmentation.js')}}"></script>
@endpush

@section('content')
<form method="post" action="{{route('list_segmentations.store')}}"  class="row g-3 mt-0 needs-validation" novalidate>
	@csrf
	<div class="card custom-card">
		<div class="card-body">
			<div class="box-body">
				<label class="form-label">{{__('app.name')}}</label>
				<input type="text" class="form-control" placeholder="{{__('app.name')}}" id="name" name="name" required>
				<div class="col-md-12 mt-3">
					<label class="form-label">{{__('app.lists')}}
						<a href="{{route('lists.create')}}" tabindex="-1">
							<i class="bi bi-plus-circle-fill text-primary"></i>
						</a>
					</label>
					@include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1, 'required' => 1])
					<div class="row">
						<div class="col-md-6">
			        <label class="form-label">{{__('app.allow_unsub')}}</label>
			        <select name="allow_unsub" class="form-select form-select-lg">
			        	<option value="Yes">{{ __('app.yes') }}</option>
			          <option value="No">{{ __('app.no')}}</option>			          
			        </select>
			      </div>
			      <div class="col-md-6">
			        <label class="form-label">{{__('app.allow_bounced')}}</label>
			        <select name="allow_bounced" class="form-select form-select-lg">
			        	<option value="Yes">{{ __('app.yes') }}</option>
			          <option value="No">{{ __('app.no')}}</option>			          
			        </select>
			      </div>
		    	</div>
				</div>
			</div>
		</div>
	</div>
	<div class="card custom-card">
		<div class="card-body">
			<div class="card-title"><h6>{{ __('app.contact_filters') }}</h6></div>
			<div class="box-body">
				<div class="box-body repeater-contact">
					<div data-repeater-list="contact_filter">
						<div data-repeater-item class="row mt-3">
							<div class="col-md-4">
								<span data-repeater-delete>AND</span>
								<select name="name" class="form-select" onchange="loadContactAction(this, '{{ __('app.use_comma_for_multiples') }}');">
									<option value=""></option>
									<option value="email">{{ __('app.email') }}</option>
									<option value="status">{{ __('app.status') }}</option>
									<option value="source">{{ __('app.source') }}</option>
								</select>
							</div>
							<div class="col-md-3">
								<span data-repeater-delete>&nbsp;</span>
								<select name="action" class="form-select"></select>
							</div>
							<div class="col-md-4">
								<span data-repeater-delete>&nbsp;</span>
								<select name="value" class="form-select"></select>
							</div>
							<div class="col-md-1" style="margin:inherit;">
								<span data-repeater-delete>&nbsp;</span>
								<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
							</div>
						</div>
					</div>
					<div class="col-12 mt-2">
						<input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="card custom-card">
		<div class="card-body">
			<div class="box-body">
				<div class="card-title"><h6>{{ __('app.custom_fields_filters') }}</h6></div>
				<div class="box-body repeater-contact">
					<div data-repeater-list="custom_fields_filter">
						<div data-repeater-item class="row mt-3">
							<div class="col-md-4">
								<span data-repeater-delete>AND</span>
								<select name="name" class="form-select">
					                <option value=""></option>
					                @if(!empty($custom_fields))
					                  @foreach($custom_fields as $custom_field)
					                    <option value="{{ $custom_field->id }}">{{ $custom_field->name }}</option>
					                  @endforeach
					                @endif
				              </select>
							</div>
							<div class="col-md-3">
								<span data-repeater-delete>&nbsp;</span>
								<select name="action" class="form-select">
					              <option value=""></option>
					              <option value="is">is</option>
					              <option value="is_not">is not</option>
					              <option value="contain">contain</option>
					              <option value="not_contain">doesn't</option>
				              </select>
							</div>
							<div class="col-md-4">
								<span data-repeater-delete>&nbsp;</span>
								<input type="text" name="value" class="form-control" placeholder="{{ __('app.use_comma_for_multiples') }}">
							</div>
							<div class="col-md-1" style="margin:inherit;">
								<span data-repeater-delete>&nbsp;</span>
								<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
							</div>
						</div>
					</div>
					<div class="col-12 mt-2">
						<input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="card custom-card">
		<div class="card-body">
			<div class="box-body">
				<div class="box-body repeater-contact">
					<div data-repeater-list="dates_filter">
						<div class="card-title"><h6>{{ __('app.date_filters') }}</h6></div>
						<div data-repeater-item class="row mt-3">
							<div class="col-md-4">
								<span data-repeater-delete>AND</span>
								<select name="name" class="form-select">
						              <option value=""></option>
					                <option value="subscription_date">{{__('app.subscription_date')}}</option>
					                @if(!empty($custom_fields))
					                  @foreach($custom_fields_date as $custom_field)
					                    <option value="{{ $custom_field->id }}">{{ $custom_field->name }}</option>
					                  @endforeach
					                @endif
				              </select>
							</div>
							<div class="col-md-3">
								<span data-repeater-delete>&nbsp;</span>
								<select name="action" class="form-select" onchange="loadDate(this)">
					                <option value=""></option>
					                <option value="is">is</option>
					                <option value="is_not">is not</option>
					                <option value="after">after</option>
					                <option value="before">before</option>
				              	</select>
							</div>
							<div class="col-md-4">
								<span data-repeater-delete>&nbsp;</span>
								<input type="text" name="value" class="form-control" id="datetime">
							</div>
							<div class="col-md-1" style="margin:inherit;">
								<span data-repeater-delete>&nbsp;</span>
								<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
							</div>
						</div>
					</div>
					<div class="col-12 mt-2">
						<input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-12 mt-5">
		<button type="submit" name="save"class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save')}}</button>
		<a href="{{route('list_segmentations.index')}}">
			<button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
		</a>
	</div>
</form>
@endsection
