<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
<div class="modal-content">
  <div class="modal-header">
    <h6 class="modal-title">{{ __('app.scheduled') }} {{ __('app.detail') }}</h6>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
  </div>
  <div class="modal-body">
    <div class="box-body">
      <div class="col-md-12">
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.name') }}</label>
          <div class="col-md-9">{{ $scheduled->name ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.status') }}</label>
          <div class="col-md-9">{{ $scheduled->status ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.scheduled_by') }}</label>
          <div class="col-md-9">{{ \App\Models\User::getUserValue($scheduled->user_id, 'name') ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.lists') }}</label>
          @php $lists = \App\Models\Lists::whereIn('id', explode(',', $scheduled->list_ids))->pluck('name')->toArray(); @endphp
          <div class="col-md-9 form-label">{{ implode(', ', $lists) }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.subject') }}</label>
          <div class="col-md-9">{{ $scheduled->email_subject ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.content') }}</label>
          <div class="col-md-9"><a class="link-info" target="_blank" href="{{route('get.schedule_campaign.content', [$scheduled->id])}}">{{ __('app.view') }}</a></div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.delivery_servers') }}</label>
          @php $sending_servers = \App\Models\SendingServer::whereIn('id', explode(',', $scheduled->sending_server_ids))->pluck('name')->toArray(); @endphp
          <div class="col-md-9">{{ implode(', ', $sending_servers) }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.total') }}</label>
          <div class="col-md-9">{{ $scheduled->total }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.created') }}</label>
          <div class="col-md-9">{{ \App\Http\Helper\Helper::datetimeDisplay($scheduled->created_at) ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.started_at') }}</label>
          <div class="col-md-9">{{ $scheduled->status != 'Preparing' && $scheduled->status != 'Draft' ? \App\Http\Helper\Helper::datetimeDisplay($scheduled->start_datetime) : '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.ended_at') }}</label>
          <div class="col-md-9">{{ $scheduled->status != 'Preparing' && $scheduled->status != 'Draft' ? \App\Http\Helper\Helper::datetimeDisplay($scheduled->end_datetime) : '---' }}</div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
    @if($scheduled->status != 'Preparing' && $scheduled->status != 'Draft')
      <a href="{{route('detail.stat.campaign', ['id' => $scheduled->stats_id])}}">
      <button type="button" class="btn btn-primary" >{{__('app.detail')}}</button>
      </a>
    @endif
  </div>
</div>
</div>