@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="card custom-card">
    <div class="card-body">
        <form method="POST" action="{{ route('roles.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
            @csrf
            <div class="col-md-12">
                <label class="form-label">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}"
                aria-label="{{__('app.name')}}" value=""  name="name" required>
            </div>
            <div class="col-md-12">
                <input type="checkbox" id="checkAll" class="form-check-input" value="Select All"> <label class="form-label">{{ __('app.select_all')}}</label>
            </div>
            <div class="row">
                @foreach($permissions as $modules)
                @foreach($modules['modules'] as $module)
                <div class="col-md-4">
                    <ul>
                        <input class="form-check-input select-all" type="checkbox" value="{{ \Illuminate\Support\Str::slug($module['title']) }}">
                        <label class="form-label">{{ $module['title'] }}</label>
                        @foreach($module['permissions'] as $key => $permission)
                        <li style="padding-left: 15px; list-style: none;">
                            <input type="checkbox" name="roles_permissions[]" class="{{ \Illuminate\Support\Str::slug($module['title']) }} form-check-input" value="{{ $key }}">
                            {{ $permission }}
                        </li>
                        @endforeach
                    </ul>
                </div>
                @endforeach            
                @endforeach
            </div>
            <div class="col-md-6">
                <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{ __('app.save') }}</button>
                <input type="hidden" value="{{ request('t') }}" name="type">
            </div>
        </form>
    </div>
</div>
@endsection
