@php $include_js = false; @endphp
@forelse($list_custom_fields as $custom_field)
  <div class="col-md-12 pt-3">
    <label class="form-label">{{ $custom_field->name }}</label>
    <div class="col-md-12">
      @if($custom_field->type == 'number')
        <input type="number" class="form-control" name="custom_fields[{{$custom_field->custom_field_id}}]" value="{{ !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id]) ? $contact_data[$custom_field->custom_field_id] : '' }}">
      @elseif($custom_field->type == 'textarea')
        <textarea class="form-control" name="custom_fields[{{$custom_field->custom_field_id}}]">{{ !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id]) ? $contact_data[$custom_field->custom_field_id] : '' }}</textarea>
      @elseif($custom_field->type == 'date')
        @php $include_js = true; @endphp
        <div class="input-group">
          <div class="input-group-text text-muted"> <i class="ri-calendar-line"></i> </div>
        <input type="text" name="custom_fields[{{$custom_field->custom_field_id}}]" class="date form-control" value="{{ !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id]) ? $contact_data[$custom_field->custom_field_id] : '' }}">
      </div>
      @elseif($custom_field->type == 'radio')
        @foreach (\App\Http\Helper\Helper::splitLineBreakWithComma($custom_field->values) as $value)
          <div class="radio list-custom-fields"><label>
            <input type="radio" name="custom_fields[{{$custom_field->custom_field_id}}]" class="form-check-input" value="{{ $value }}" {{ !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id]) && $contact_data[$custom_field->custom_field_id] == $value ? 'checked="checked"' : '' }}> {{$value}}
            </label>
          </div>
        @endforeach
      @elseif($custom_field->type == 'checkbox')
        @foreach (\App\Http\Helper\Helper::splitLineBreakWithComma($custom_field->values) as $value)
        @php $contact_data_chks = !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id])  ? preg_split("/(,|[||])/", $contact_data[$custom_field->custom_field_id]) : ''; 
        if(!empty($contact_data_chks)) {$contact_data_chks = array_map('trim', $contact_data_chks);} @endphp
          <div class="checkbox list-custom-fields"><label>
            <input type="checkbox" class="form-check-input" name="custom_fields[{{$custom_field->custom_field_id}}][]" value="{{ $value }}" {{ !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id]) && in_array($value, $contact_data_chks) ? 'checked="checked"' : '' }}> {{$value}}
            </label>
          </div>
        @endforeach
      @elseif($custom_field->type == 'dropdown')
        <select name="custom_fields[{{$custom_field->custom_field_id}}]"  class="form-control">
          @foreach (\App\Http\Helper\Helper::splitLineBreakWithComma($custom_field->values) as $value)
             <option value="{{ $value }}" {{ !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id]) && $contact_data[$custom_field->custom_field_id] == $value ? 'selected="selected"' : '' }}>{{ $value }}</option>
          @endforeach
        </select>
      @else
        <input type="text" class="form-control" name="custom_fields[{{$custom_field->custom_field_id}}]" value="{{ !empty($contact_data) && !empty($contact_data[$custom_field->custom_field_id]) ? $contact_data[$custom_field->custom_field_id] : '' }}">
      @endif
    </div>
  </div>
@empty
  <label class="form-label">{{ __('app.no_custom_field') }}</label>
@endforelse
@if($include_js)
<script>
(function () {
    'use strict';
    flatpickr(".date");
})();
</script>
@endif