@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [0, 9]}],
        "order": [[ 1, "desc" ]],
        "lengthMenu": [[100, 500, 1000], [100, 500, 1000]],
        "ajax": {
          "url" : $('#route-contacts').data('route'),
          "data" : {
            "list_id" : $('#list-id').data('value')
          }
        },
    });

    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <select class="form-select" id="list_id" name="list_id" onchange="location.href='{{ route('contacts.index') }}?list_id=' + this.value">
            <option value="">{{__('app.all_contacts')}}</option>
            @foreach(\App\Models\Lists::groupLists() as $group)
              <optgroup label="{{ $group->name }}">
              @foreach($group->lists as $list)
                <option value="{{$list->id}}" {{$list->id == $list_id ? 'selected' : ''}}>{{$list->name}}</option>
              @endforeach
            @endforeach
          </select>
        <div class="card custom-card">
            
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <a href="{{route('contacts.create')}}"><button id="addRow" class="btn btn-primary" style="margin: 0px; display: none;"">{{__('app.add_new_contact')}}</button></a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">{{__('app.actions')}}</button>
                                <ul class="dropdown-menu" style="">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('contacts.destroy', [0]) }}')"><i class="bi bi-trash"></i> {{ __('app.delete') }}</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.email') }}</th>
                                <th>{{ __('app.list') }}</th>
                                <th>{{ __('app.active') }}</th>
                                <th>{{ __('app.unsub') }}</th>
                                <th>{{ __('app.confirmed') }}</th>
                                <th>{{ __('app.verified') }}</th>                                
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-contacts" data-route="{{ route('get.contacts') }}"></span>
<span id="list-id" data-value="{{ $list_id }}"></span>
@include('includes.datatables')
@endsection
