@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
(function () {
   'use strict';
   $("#list_ids").change(function () {
      var list_id = $('#list_ids').val();
      if(list_id == '') {
         $('#list_custom_fields').html('');
         return;
      }
      loadListCustomFields(list_id);
   });
})();

loadListCustomFieldsWithData();
</script>
@endpush

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <label class="col-md-12"><h6 class="text-primary">{{__('app.general_info')}}</h6></label>
      <form method="POST" action="{{ route('contacts.update', $contact->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
         <input type="hidden" name="list_id" id="list-id" value="{{ $contact->list_id }}">
         <input type="hidden" name="contact_id" id="contact-id" value="{{ $contact->id }}">
         @csrf       
         @method('PUT')
         <div class="col-md-6 mt-1">
            <label class="form-label">{{__('app.list')}}</label>
            <input type="text" disabled class="form-control" value="{{ $contact->list->name }}" />
         </div>
         <div class="col-md-6 mt-1">
            <label class="form-label">{{__('app.email')}}</label>
            <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ $contact->email }}" name="email" required>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.active')}}</label>
            <select name="is_active" class="form-select form-select-lg">
               <option value="1" {{ $contact->is_active ? 'selected' : '' }}>{{ __('app.yes') }}</option>
               <option value="0" {{ $contact->is_active ? '' : 'selected' }}>{{ __('app.no')}}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.subscribed')}}</label>
            <select name="is_unsubscribed" class="form-select form-select-lg">
               <option value="0" {{ $contact->is_unsubscribed ? '' : 'selected' }}>{{ __('app.yes') }}</option>
               <option value="1" {{ $contact->is_unsubscribed ? 'selected' : '' }}>{{ __('app.no')}}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.confirmed')}}</label>
            <select name="is_confirmed" class="form-select form-select-lg">
               <option value="0" {{ $contact->is_confirmed ? '' : 'selected' }}>{{ __('app.no')}}</option>
               <option value="1" {{ $contact->is_confirmed ? 'selected' : '' }}>{{ __('app.yes') }}</option>
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.verified')}}</label>
            <select name="is_verified" class="form-select form-select-lg">
               <option value="0" {{ $contact->is_verified ? '' : 'selected' }}>{{ __('app.no')}}</option>
               <option value="1" {{ $contact->is_verified ? 'selected' : '' }}>{{ __('app.yes') }}</option>
            </select>
         </div>

         <label class="col-md-12 mt-5"><h6 class="text-primary">{{__('app.custom_fields')}}</h6></label>
         <div class="col-md-12" id="list_custom_fields">
            <label class="form-label">{{ __('app.no_custom_field') }}</label>
         </div>

         <div class="col-12">
            <button type="submit" name="update" value="update" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
            <a href="{{route('contacts.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection