@php
session_start();
$_SESSION['user_id'] = Auth::user()->id; // will be us in imageuploader
$_SESSION['lang'] = Auth::user()->language // will be us in imageuploader
@endphp
@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
@endpush

@section('styles')
<style type="text/css">
  .modal-body {
    overflow: scroll !important;
   }
   .select2-container {
    z-index: 10 !important;
   }
</style>
@endsection

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('broadcasts.update', $broadcast->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf
         @method('PUT')    
         <div class="col-md-6">
            <label class="form-label">{{__('app.group')}}
               <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_campaigns')])}}');">
                  <i class="bi bi-plus-circle-fill text-primary"></i>
               </a>
            </label>
            <select name="group_id" class="single-select form-select" id="group_id" required>
               <option value="">{{__('app.select_group')}}</option>
               @foreach($groups as $id => $group_name)
               <option value="{{ $id }}" {{ $broadcast->group_id == $id ? 'selected' : '' }}>{{$group_name}}</option>
               @endforeach
            </select>
            <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ $broadcast->name }}" name="name" required>
         </div>
         <div class="col-md-12">
            <label class="form-label">{{__('app.subject')}}</label>
            <a tabindex="-1" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="top" data-bs-custom-class="header-primary" title="Subject Help" data-bs-content="You can use all shortcodes in subject line."><i class="bi bi-question-square-fill text-primary"></i></a>

            <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="{{ $broadcast->email_subject }}" name="email_subject" required>
         </div>
         
         <div class="col-md-12">
            <label class="form-label">{{__('app.content')}} <span class="ps-5"></span></label>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('shortcodes') }}');" tabindex="-1">{{ __('app.shortcodes') }}</button><span class="ps-1"></span>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('templates.all') }}');" tabindex="-1">Import Template</button> 
            <textarea class="form-control" id="content_html" name="content_html" rows="10">{{\App\Http\Helper\Helper::decodeString($broadcast->content_html) }}</textarea>
         </div>
         <div class="col-12">
            <button type="submit" name="save_exit" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_exit')}}</button>
            <button type="submit" name="save_continue" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_continue_edit')}}</button>
            <button type="button" id="validate-imap" onclick="viewModal('modal', '{{route('send.email', [$broadcast->id, 0, 0])}}')" class="btn btn-info"><i class=""></i> {{__('app.send_test_email')}}</button>
            <a href="{{route('broadcasts.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection