@php
session_start();
$_SESSION['user_id'] = Auth::user()->id; // will be us in imageuploader
$_SESSION['lang'] = Auth::user()->language // will be us in imageuploader
@endphp
@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
@endpush

@section('styles')
<style type="text/css">
  .modal-body {
    overflow: scroll !important;
   }
   .select2-container {
    z-index: 10 !important;
   }
</style>
@endsection

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('broadcasts.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf       
         <div class="col-md-6">
            <label class="form-label">{{__('app.group')}}
               <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_campaigns')])}}');">
                  <i class="bi bi-plus-circle-fill text-primary"></i>
               </a>
            </label>
            <select name="group_id" class="single-select form-select" id="group_id" required>
               <option value="">{{__('app.select_group')}}</option>
               @foreach($groups as $id => $group_name)
               <option value="{{ $id }}" {{ old('group_id') == $id ? 'selected' : '' }}>{{$group_name}}</option>
               @endforeach
            </select>
            <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ old('name') }}" name="name" required>
         </div>
      <div class="col-md-12">
         <label class="form-label">{{__('app.subject')}}</label>
            <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.subject')}}"
            data-bs-content="{{__('app.subject_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square-fill text-primary"></i>
            </a>
         <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="{{ old('email_subject') }}" name="email_subject" required>
      </div>
      <div class="col-md-12">
         <label class="form-label">{{__('app.content')}} <span class="ps-5"></span></label>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('shortcodes') }}');" tabindex="-1">{{ __('app.shortcodes') }}</button><span class="ps-1"></span>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('templates.all') }}');" tabindex="-1">Import Template</button>         
         <textarea class="form-control" id="content_html" name="content_html" rows="10">{{ $html ?? '' }}</textarea>
      </div>
      <div class="col-12">
         <button type="submit" name="save_exit" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_exit')}}</button>
         <button type="submit" name="save_continue" value="1" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save_continue_edit')}}</button>
         <a href="{{route('broadcasts.index')}}">
          <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
        </a>
      </div>
   </form>
</div>
</div>
@endsection