@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [0, 6]}],
    "order": [[ 1, "desc" ]],
    "lengthMenu": [[100, 500, 1000], [100, 500, 1000]],
    "ajax": $('#route-system-bounced').data('route'),
    });
    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-2">
                        <div class="col-md-6" id="addRow" style="display: none;">
                            <a href="javascript:;" onclick="viewModal('modal', '{{route('system.bounced.import')}}');"><button class="btn btn-primary" style="margin: 0px;">{{__('app.import_system_bounced')}}</button></a>
                            <a href="javascript:;" onclick="exportBounced('{{ route('system.bounced.export') }}', '{{__('app.export_system_bounced_alert')}}', '{{ __('app.msg_export_system_bounced') }}');"><button class="btn btn-primary" style="margin: 0px;">{{__('app.export_system_bounced')}}</button></a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">{{__('app.actions')}}</button>
                                <ul class="dropdown-menu" style="">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('system.bounced.destroy', [0]) }}')"><i class="bi bi-trash"></i> {{ __('app.delete') }}</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.email') }}</th>
                                  <th>{{ __('app.type') }}</th>
                                  <th>{{ __('app.code') }}</th>
                                  <th>{{ __('app.detail') }}</th>
                                  <th>{{ __('app.datetime') }}</th>
                                  <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-system-bounced" data-route="{{ route('get.system.bounced') }}"></span>
@include('includes.datatables')
@endsection
