@extends('layouts.login')

@section('content')
<div class="h6">{{ __('app.reset_password') }}</div>
@if (session('status'))
    <div class="alert alert-success" role="alert">
        {{ session('status') }}
    </div>
@endif

<form method="POST" action="{{ route('password.email') }}">
    @csrf
    <div class="row mb-3">
         <label for="email" class="form-label text-default">{{ __('app.login_username') }} <sup class="fs-12 text-danger">*</sup><a href="{{ route('login') }}" class="float-end fw-normal text-muted">{{ __('app.sign_in') }}</a></label>

        <div class="col-xl-12 mb-2">
            <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="email" autofocus placeholder="{{ __('app.login_username') }}">

            @error('email')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>
    </div>

    <div class="row mb-0">
        <div class="col-md-6 offset-md-4">
            <button type="submit" class="btn btn-primary btn-loading"> <i class=""></i>
                {{ __('app.reset_password') }}
            </button>
        </div>
    </div>
</form>
@endsection
