@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [3,5]}],
    "order": [[5, "DESC"]],
    "lengthMenu": [[50, 100, 500], [50, 100, 500]],
    "ajax": {
      "url" : "{{ route('stats.triggers') }}"
    },
    });

    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
          <th>{{ __('app.based_on') }}</th>
          <th>{{ __('app.action') }}</th>
          <th>{{ __('app.scheduled_by') }}</th>
          <th>{{ __('app.created') }}</th>
          <th>{{ __('app.detail') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('includes.modal')
@include('includes.datatables')
@endsection
