// Toggle password visibility
document.querySelectorAll('.toggle-password').forEach(function (button) {
  button.addEventListener('click', function () {
    const target = document.querySelector(this.getAttribute('data-target'));
    const type = target.type === 'password' ? 'text' : 'password';
    target.type = type;

    // Toggle the eye icon
    const icon = this.querySelector('i');
    icon.classList.toggle('fa-eye');
    icon.classList.toggle('fa-eye-slash');
  });
});

// Bootstrap form validation
(function () {
  'use strict';
  var forms = document.querySelectorAll('.needs-validation');
  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault();
          event.stopPropagation();
        }
        form.classList.add('was-validated');
      }, false);
    });
})();

$(document).ready(function () {
  $(".btn-loading").click(function() {
    $(this).find("i").addClass("spinner-border spinner-border-sm align-middle");
  });
});

function install(frm) {
    if (frm.checkValidity() === false) {
      $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      return false;
    } else {
      $('#msg').html('We are currently processing your request. Please wait a few minutes. Thank you for your patience!');
      $.ajax({
        url: '/installation',
        method: 'POST',
        data: $('#frm-install').serialize(),
        success: function(result) {
          console.log(result);
          if(result.success) {
            $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
            $('#cronjob').html(result.msg);
            $('#page1').hide();
            $("#login").attr("href", $('#app_url').val());
            $('#page2').show();
          } else {
            $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
            $('#msg').html(result.msg);
          }
          return false;
        },
        error: function (result) {
          alert('Error');
          $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
          $('#msg').html(result);
        }
      });
      return false;
    }
    return false;
  }