<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $attributes['cron_timestamp'] = '2024-01-01 00:00:00';
        $attributes['max_file_size'] = '2';
        $settings = Setting::create([
            'app_name' => 'Relayzo', 
            'app_url' => 'https://relayzo.com',
            'sending_type' => 'php_mail',
            'attributes' => json_encode($attributes),
        ]);
    }
}
