<?php
  
namespace Database\Seeders;
  
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
  
class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
           __('app.lists'),
           __('app.contacts'),
           __('app.campaigns'),
           __('app.servers'),
           __('app.domains'),
           __('app.contents'),
           __('app.user_management'),
           __('app.analatics'),
           __('app.settings'),
           __('app.miscellaneous'),
           __('app.tools'),
        ];
        
        foreach ($permissions as $permission) {
            try {
             Permission::create(['name' => $permission]);
            } catch(\Exception $e) { }
        }
    }
}
