<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EmailsPagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
            'name' => 'Notification Email (Contact Unsubscribed)',
            'slug' => 'notify-email-contact-unsub',
            'type' => 'email',
            'app_id' => 1,
            'order' => 4,
            'email_subject' => 'Contact has been unsubscribed',
            'content' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
  <title>Subscriber Unsubscribed</title>
  <style type="text/css">body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #1F1F34;
            color: #fff;
            text-align: center;
            padding: 15px 20px;
        }
        .content {
            padding: 20px;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #1F1F34;
            font-size: 12px;
            color: #777;
        }
        .footer a {
            color: #f56342;
            text-decoration: none;
        }
  </style>
</head>
<body>
<div class="container">
<div class="header">
<h1>Subscriber Unsubscribed</h1>
</div>

<div class="content">
<p>Hello,</p>

<p>This is to inform you that a subscriber has successfully unsubscribed from the mailing list([$list-name$]).</p>

<p><strong>Email Address:</strong>&nbsp;[$receiver-email$]</p>
</div>

<div class="footer">
<p><span style="color:#ffffff;">&copy; 2025 Relayzo. All rights reserved</span></p>
</div>
</div>
</body>
</html>
'
            ],
            [
            'name' => 'Notification Email (Contact Added)',
            'slug' => 'notify-email-contact-added',
            'type' => 'email',
            'app_id' => 1,
            'order' => 3,
            'email_subject' => 'Contact has been added to a list',
            'content' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
  <title>Subscriber Unsubscribed</title>
  <style type="text/css">body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #1F1F34;
            color: #fff;
            text-align: center;
            padding: 15px 20px;
        }
        .content {
            padding: 20px;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #1F1F34;
            font-size: 12px;
            color: #777;
        }
        .footer a {
            color: #f56342;
            text-decoration: none;
        }
  </style>
</head>
<body>
<div class="container">
<div class="header">
<h1>Subscriber Added</h1>
</div>

<div class="content">
<p>Hello,</p>

<p>This is to inform you that a subscriber has successfully added to the mailing list([$list-name$]).</p>

<p><strong>Email Address:</strong>&nbsp;[$receiver-email$]</p>
</div>

<div class="footer">
<p><span style="color:#ffffff;">&copy; 2025 Relayzo. All rights reserved</span></p>
</div>
</div>
</body>
</html>
'
            ],
            [
            'name' => 'Unsubscribe Email',
            'slug' => 'unsub-email',
            'type' => 'email',
            'app_id' => 1,
            'order' => 2,
            'email_subject' => 'Unsubscribed',
            'content' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
  <title>Subscriber Unsubscribed</title>
  <style type="text/css">body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #1F1F34;
            color: #fff;
            text-align: center;
            padding: 15px 20px;
        }
        .content {
            padding: 20px;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #1F1F34;
            font-size: 12px;
            color: #777;
        }
        .footer a {
            color: #f56342;
            text-decoration: none;
        }
  </style>
</head>
<body>
<div class="container">
<div class="header">
<h1>Unsubscribe Confirmation</h1>
</div>

<div class="content">
<p>Hello [$receiver-email$],</p>

<p>This email is to confirm that you have successfully unsubscribed from our mailing list. You will no longer receive updates or promotional emails from us.</p>

<p>We&rsquo;re sorry to see you go, but we respect your decision. If you have any feedback, feel free to share it with us at [$sender-email$].</p>

<p>Best regards,<br />
Team Relayzo</p>
</div>

<div class="footer">
<p><span style="color:#ffffff;">&copy; 2025 Relayzo. All rights reserved</span></p>
</div>
</div>
</body>
</html>
'
            ],
            [
            'name' => 'Welcome Email',
            'slug' => 'welcome-email',
            'type' => 'email',
            'app_id' => 1,
            'order' => 1,
            'email_subject' => 'Welcome!',
            'content' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
  <title>Subscriber Unsubscribed</title>
  <style type="text/css">body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #1F1F34;
            color: #fff;
            text-align: center;
            padding: 15px 20px;
        }
        .content {
            padding: 20px;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #1F1F34;
            font-size: 12px;
            color: #777;
        }
        .footer a {
            color: #f56342;
            text-decoration: none;
        }
  </style>
</head>
<body>
<div class="container">
<div class="header">
<h1>Welcome to Relayzo!</h1>
</div>

<div class="content">
<p>Hi [$receiver-email$],</p>

<p>We&#39;re thrilled to welcome you to our community! Get ready to receive the latest updates, exclusive offers, and valuable content delivered straight to your inbox.</p>

<p>Thank you for subscribing!</p>

<p>Best regards,<br />
Team Relayzo</p>
</div>

<div class="footer">
<p><span style="color:#ffffff;">&copy; 2025 Relayzo. All rights reserved<br />
<a href="[$unsub-link$]">unsubscribe</a></span></p>
</div>
</div>
</body>
</html>
'
            ],
            [
            'name' => 'Unsubscribe Page (Confirmation)',
            'slug' => 'unsub-confirm',
            'type' => 'page',
            'app_id' => 1,
            'order' => 1,
            'email_subject' => null,
            'content_html' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
  <title>Subscriber Unsubscribed</title>
  <style type="text/css">body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #1F1F34;
            color: #fff;
            text-align: center;
            padding: 15px 20px;
        }
        .content {
            padding: 20px;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #1F1F34;
            font-size: 12px;
            color: #777;
        }
        .footer a {
            color: #f56342;
            text-decoration: none;
        }
  </style>
</head>
<body>
<div class="container">
<div class="header">
<h1><strong>Confirm Your Unsubscription</strong></h1>
</div>

<div class="content">
<p>We&rsquo;ve received a request to unsubscribe you from our mailing list. To complete the process and stop receiving emails from us, please click the link below to confirm your unsubscription:</p>

<p><a href="[$unsub-confirm$]" rel="noopener"><strong>Confirm Unsubscription</strong></a></p>

<p>If you did not request to unsubscribe, or if this was a mistake, please ignore this email, and you will remain on our list.</p>

<p>We&rsquo;re sorry to see you go, but we respect your decision. If you have any feedback, feel free to share it with us at [$sender-email$].</p>
</div>

<div class="footer">
<p><span style="color:#ffffff;">&copy; 2025 Relayzo. All rights reserved</span></p>
</div>
</div>
</body>
</html>
'
            ],
            [
            'name' => 'Unsubscribe Page (Final)',
            'slug' => 'unsub',
            'type' => 'page',
            'app_id' => 1,
            'order' => 2,
            'email_subject' => null,
            'content_html' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8">
  <title>Subscriber Unsubscribed</title>
  <style type="text/css">body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #1F1F34;
            color: #fff;
            text-align: center;
            padding: 15px 20px;
        }
        .content {
            padding: 20px;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #1F1F34;
            font-size: 12px;
            color: #777;
        }
        .footer a {
            color: #f56342;
            text-decoration: none;
        }
  </style>
</head>
<body>
<div class="container">
<div class="header">
<h1>Unsubscribe Confirmation</h1>
</div>

<div class="content">
<p>Hello [$receiver-email$],</p>

<p>Thank you for being part of our community. Your request to unsubscribe has been processed, and you will no longer receive emails from us.</p>

<p>We&rsquo;re sorry to see you go, but we respect your decision. If there&rsquo;s anything we could have done better, we&rsquo;d love to hear your feedback at [$sender-email$].</p>
</div>

<div class="footer">
<p><span style="color:#ffffff;">&copy; 2025 Relayzo. All rights reserved</span></p>
</div>
</div>
</body>
</html>
'
            ]
        ];
        DB::table('emails_pages')->truncate();
        DB::table('emails_pages')->insert($data);
    }
}
