<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trigger_schedule_stats', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('trigger_id')->nullable();
            $table->string('trigger_name')->nullable();
            $table->string('email_subject')->nullable();
            $table->longText('content')->nullable();
            $table->string('schedule_by')->nullable();
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trigger_schedule_stats');
    }
};
