<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sending_domains', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('group_id')->nullable();
            $table->string('domain')->nullable();
            $table->enum('protocol', ['http://', 'https://'])->default('https://');
            $table->boolean('is_active')->default(true);
            $table->boolean('auto_verification')->default(false);
            $table->text('public_key')->nullable();
            $table->text('private_key')->nullable();
            $table->string('host_dkim')->nullable();
            $table->text('value_dkim')->nullable();
            $table->string('host_spf')->nullable();
            $table->text('value_spf')->nullable();
            $table->string('host_dmarc')->nullable();
            $table->text('value_dmarc')->nullable();
            $table->boolean('is_verified_key')->default(false);
            $table->boolean('is_verified_spf')->default(false);
            $table->boolean('is_verified_dmarc')->default(false);
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();

            $table->foreign('group_id')->references('id')->on('groups')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sending_domains');
    }
};
