<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bounces', function (Blueprint $table) {
            $table->id();
            $table->string('email')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_validate')->default(false);
            $table->enum('method', ['imap', 'pop3'])->default('imap');
            $table->string('host')->nullable();
            $table->string('username')->nullable();
            $table->string('password', 255)->nullable();
            $table->unsignedInteger('port')->nullable();
            $table->enum('encryption', ['ssl', 'tls', 'none'])->default('ssl');
            $table->enum('validate_cert', ['Yes', 'No'])->default('Yes');
            $table->enum('delete_after_processing', ['Yes', 'No'])->default('No');
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bounces');
    }
};
