<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('list_custom_fields', function (Blueprint $table) {
            $table->id('id');
            $table->unsignedBigInteger('list_id');
            $table->unsignedBigInteger('custom_field_id');

            $table->foreign('list_id')->references('id')->on('lists')->onDelete('cascade');
            $table->foreign('custom_field_id')->references('id')->on('custom_fields')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('list_custom_fields');
    }
};
