@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(function(){
  'use strict';
  loadSendingServerAttributes($("#type").val(), 'edit', '{{ $sending_server->id}}');
  $("#speed").val() == 'limited' ? $("#speed-attributes").show() : '';
});
</script>
@endpush

@section('styles')
<style type="text/css">
  #group_id + .select2-container {
    z-index: 0 !important;
  }
  .modal-body {
    overflow: scroll !important;
   }
   .select2-container {
    z-index: 10 !important;
   }
</style>
@endsection

@section('content')
<div class="card custom-card">
  <div class="card-body">
    <label class="col-md-12"><h6 class="text-primary">{{__('app.general_info')}}</h6></label>
    <form method="POST" action="{{ route('sending_servers.update', $sending_server->id) }}" class="row g-3 mt-0 needs-validation" novalidate>
      @csrf
      @method('PUT')
      <div class="col-md-4 mt-1">
        <label class="form-label">{{__('app.group')}}
          <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_sending_servers')])}}');">
            <i class="bi bi-plus-circle-fill text-primary"></i>
          </a>
        </label>
        <select name="group_id" class="single-select form-control" id="group_id" required>
          <option value="">{{__('app.select_group')}}</option>
          @foreach($groups as $id => $group_name)
            <option value="{{ $id }}" {{ ($id == $sending_server->group_id) ? 'selected' : '' }}>{{ $group_name }}</option>
          @endforeach
        </select>
        <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
      </div>
      <div class="col-md-2 mt-1">
        <label class="form-label">{{__('app.status')}}</label>
        <select name="status" class="single-select form-control">
          <option value="Active" {{ $sending_server->status == 'Active' ? 'selected' : '' }}>{{ __('app.active')}}</option>
          <option value="Inactive" {{ $sending_server->status == 'Inactive' ? 'selected' : '' }}>{{ __('app.in_active') }}</option>
        </select>
      </div>
      <div class="col-md-6 mt-1">
        <label class="form-label">{{__('app.name')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{$sending_server->name}}" name="name" required>
      </div>

      <div class="col-md-12">
        <label class="form-label">{{__('app.detail')}}</label>
        <textarea class="form-control" placeholder="{{__('app.detail')}}" row="3" name="detail">{{$sending_server->detail}}</textarea>
      </div>

      <label class="col-md-12 mt-3"><h6 class="text-primary">{{__('app.delivery_server')}}</h6></label>
      <div class="col-md-12">
        <select name="type" id="type" class="form-select form-select-lg">
          @foreach(\App\Http\Helper\Helper::sendingServers() as $type => $value)
            <option value="{{ $type }}" {{ $type == $sending_server->type ? 'selected="selected"' : '' }}>{{ $value }}</option>
          @endforeach
        </select>
      </div>
      
      <div id="sending-attributes"></div>

      <label class="col-md-12 mt-3"><h6 class="text-primary">{{__('app.from_detail')}}</h6></label>
      <div class="col-md-3 mt-1">
        <label class="form-label">{{__('app.from_name')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{ $sending_server->from_name }}" name="from_name" required>
      </div>
      <div class="col-md-6 mt-1">
        <label class="form-label">{{__('app.from_email')}}
          <a href="{{route('sending_domains.index')}}" tabindex="-1">
            <i class="bi bi-plus-circle-fill text-primary"></i>
          </a>
        </label>
        <div class="input-group">
          <div style="width: 35%;">
            <input type="text" name="from_email_part1" class="form-control" placeholder="{{__('app.from_email_example')}}" value="{{strstr($sending_server->from_email, '@', true)}}" required >
          </div>
          <span class="input-group-text">@</span>
          @php $from_email_domain = explode('@', $sending_server->from_email)[1]; @endphp
          <select name="from_email_part2" class="form-select" required>
            <option value="">{{__('app.select_domain')}}</option>
            @foreach($sending_domains as $sending_domain)
              <option value="{{ $sending_domain->domain }}" {{ ($from_email_domain == $sending_domain->domain) ? 'selected="selected"' : '' }}>{{ $sending_domain->domain }}</option>
            @endforeach
          </select>
        </div>
      </div>
      <div class="col-md-3 mt-1">
        <label class="form-label">{{__('app.reply_email')}}</label>
        <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="{{ $sending_server->reply_email }}" name="reply_email" required>
      </div>

      <label class="col-md-12 mt-4"><h6 class="text-primary">{{__('app.other_detail')}}</h6></label>
      <div class="col-md-6 mt-1">
        <label class="form-label">{{__('app.bounce_email')}}
        <a href="{{route('bounces.create')}}" tabindex="-1">
          <i class="bi bi-plus-circle-fill text-primary"></i>
        </a>
        </label>
        <select name="bounce_id" id="bounce-id" class="form-select form-select-lg">
          <option value="0">{{ __('app.none') }}</option>
          @foreach($bounces as $bounce)
            <option value="{{ $bounce->id }}" {{ $bounce->id == $sending_server->bounce_id ? 'selected="selected"' : '' }}>{{ $bounce->email }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-6 mt-1">
        <label class="form-label">{{__('app.tracking_domain')}}
          <a href="{{route('tracking_domains.index')}}" tabindex="-1">
            <i class="bi bi-plus-circle-fill text-primary"></i>
          </a>
        </label>
        <select name="tracking_domain"  class="form-select form-select-lg">
          <option value="{{\App\Http\Helper\Helper::getAppURL()}}">{{\App\Http\Helper\Helper::getAppURL()}}</option>
          @foreach($tracking_domains as $tracking_domain)
            @php
            $sending_domain_tracking = "{$tracking_domain->protocol}{$tracking_domain->domain}";
            @endphp
            <option value="{{ $tracking_domain->protocol }}{{ $tracking_domain->domain }}" {{($sending_server->tracking_domain == $sending_domain_tracking)  ? 'selected="selected"' : '' }}>{{ $tracking_domain->protocol }}{{ $tracking_domain->domain }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-12 mt-3">
        <label class="form-label">{{__('app.sending_speed')}} {{$sending_server->speed}}</label>
        <select name="speed" id="speed" class="form-select form-select-lg">
          <option value="unlimited" {{ json_decode($sending_server->speed_attributes)->speed == 'unlimited' ? 'selected="selected"' : '' }}>{{ __('app.unlimited') }}</option>
          <option value="limited" {{ json_decode($sending_server->speed_attributes)->speed == 'limited' ? 'selected="selected"' : '' }}>{{ __('app.limited') }}</option>
        </select>
      </div>

      <div class="col-md-12 mt-3" id="speed-attributes" style="display: none;">
        <div class="row">
          <div class="col-md-offset-2 col-md-6">
            <input type="number" class="form-control" name="limit" value="{{ json_decode($sending_server->speed_attributes)->limit }}">
          </div>
          <div class="col-md-6"> 
            <select name="duration" class="form-select form-select-lg" >
              <option value="hourly" {{ json_decode($sending_server->speed_attributes)->duration == 'hourly' ? 'selected="selected"' : '' }}>{{ __('app.hourly') }}</option>
              <option value="daily" {{ json_decode($sending_server->speed_attributes)->duration == 'daily' ? 'selected="selected"' : '' }}>{{ __('app.daily') }}</option>
            </select>
          </div>
        </div>
        </div>

      <div class="col-12">
        <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.update')}}</button>
        <a href="{{route('sending_servers.index')}}">
        <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button></a>
        <button type="button" class="btn btn-info btn-loading" onclick="viewModal('modal', '{{ route('send.email', [0, $sending_server->id, 0, "$sending_server->name"]) }}');">{{ __('app.send_test_email') }}</button>
      </div>
    </form>
  </div>
</div>
@include('includes.modal')
@endsection