<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
	<div class="modal-content">
  <div class="modal-header">
      <h6 class="modal-title">{{__('app.detail')}}
      </h6>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
    </div>
  <div class="modal-body">
    <div class="box-body">
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.name') }}</label>
        <div class="col-md-8">{{ $list->name }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.group') }}</label>
        <div class="col-md-8">{{ $list->group->name }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.double_optin') }}</label>
        <div class="col-md-8">{{ $list->double_optin == 'Yes' ? __('app.yes') : __('app.no') }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.welcome_email') }}</label>
        <div class="col-md-8">{{ $list->welcome_email == 'Yes' ? __('app.yes') : __('app.no') }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.unsub_email') }}</label>
        <div class="col-md-8">{{ $list->unsub_email == 'Yes' ? __('app.yes') : __('app.no') }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.notify_email') }}</label>
        <div class="col-md-8">{{ $list->notify_email ?? '---' }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.from_name') }}</label>
        <div class="col-md-8">{{ $list->from_name ?? '---' }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.from_email') }}</label>
        <div class="col-md-8">{{ $list->from_email ?? '---' }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.reply_email') }}</label>
        <div class="col-md-8">{{ $list->reply_email ?? '---' }}</div>
      </div>
      <div class="row mb-3">
        <label class="col-md-4 form-label">{{ __('app.created') }}</label>
        <div class="col-md-8">{{ \App\Http\Helper\Helper::datetimeDisplay($list->created_at) }}</div>
      </div>

      <div class="row mb-3">
      <h6>{{ __('app.custom_fields') }}</h6>
      </div>

      <div class="row mb-3">
      <div class="form-label col-md-6"><label>{{ __('app.name') }}</label></div>
      <div class="form-label col-md-6"><label>{{ __('app.type') }}</label></div>
  </div>
      @php ($custom_fields = $list->customFields) @endphp
      @forelse($custom_fields as $custom_field)
      <div class="row mb-3">
        <div class="form-group col-md-6">{{ $custom_field->name }}</div>
        <div class="form-group col-md-6">{{ ucfirst($custom_field->type) }}</div>
      </div>
      @empty
        <div class="form-label col-md-12 text-center">{{ __('app.no_record_found') }}</div>
      @endforelse
    </div>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
    <a href="{{ route('lists.edit', [$list->id]) }}"><button type="button" class="btn btn-primary">{{ __('app.edit') }}</button></a>
  </div>
  </div>
</div>