@if($popup)
<script type="text/javascript">
(function () {
    "use strict";
    document.getElementById('modal').addEventListener('shown.bs.modal', function () {
      const multipleDefault = new Choices(document.getElementById('list_ids'), {
        allowHTML: true,
        removeItemButton: true,
        dropdownParent: document.getElementById('modal') // Attach to modal
      });
    });
});
</script>
@else
  @push('scripts')
  <script type="text/javascript">
    (function () {
      "use strict";
      const multipleDefault = new Choices(document.getElementById('broadcast_ids'), {
        allowHTML: true,
        removeItemButton: true,
      });
    })();
  </script>
  @endpush
@endif
<select name="broadcast_ids[]" class="form-select form-select-lg" id="broadcast_ids" @if(isset($multiple) && $multiple == 1) multiple @endif  @if(isset($required)) required @endif>
  <option value="">{{__('app.select_broadcast')}}</option>
  @foreach(\App\Models\Broadcast::groupBroadcasts() as $group)
    <optgroup label="{{ $group->name }}">
      @foreach($group->broadcasts as $broadcast)
        <option value="{{ $broadcast->id }}" {{ ((!empty($broadcast_ids) && in_array($broadcast->id, $broadcast_ids)) || (isset($broadcast_id) && $broadcast->id == $broadcast_id)) ? 'selected="selected"' : '' }}>{{$broadcast->name}} ({{$broadcast->total_contacts ?? 0}})</option>
      @endforeach
    </optgroup>
  @endforeach
</select>
<div class="invalid-feedback">Please select at least one option.</div>