@if(!empty($breadcrumbs))
<div class="d-flex align-items-center justify-content-between page-header-breadcrumb flex-wrap gap-2">
   <h1 class="page-title fw-medium fs-18 mb-0">{{$page_title}}</h1>
   <div>
      <nav>
         <ol class="breadcrumb mb-1">
         	@foreach($breadcrumbs as $name => $link)
	            <li class="breadcrumb-item {{ $page_title == $name ? 'active' : '' }}" aria-current="page"><a href="{{$link}}">{{$name}}</a></li>            
	        @endforeach
         </ol>
      </nav>
   </div>
</div>
@endif
@if(Session::has('impersonate'))
<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="alert alert-danger text-center">
            <i class="bi bi-exclamation-triangle"></i>
            {!! __('app.msg_impersonate') !!} <strong>{{ Auth::user()->name }}</strong>
            <a class="link-info" href="{{ route('logout') }}"
                onclick="event.preventDefault();
                document.getElementById('logout-form').submit();">
                <font class="profil-logout">
                    {{ __('app.logout') }}
                </font>
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
            </form>
            <span class="mx-3"><strong>OR</strong></span>
            {{ __('app.back_to') }}      
            <form action={{route('user.impersonate', config('custom.app_id'))}} method="POST" class="d-inline">
                @csrf
                <button type="submit" class="link-info" style="background: none; border: none; padding: 0; color: inherit; cursor: pointer;">
                    <i class="bi bi-people"></i> {{ __('app.superadmin') }}
                </button>
            </form>
        </div>
    </div>
</div>
@endif

@if (count($errors) > 0)
    <div class="alert alert-danger">
      <strong>{{__('app.whoops')}}!</strong> {{__('app.problem_with_inputs')}}.<br><br>
      <ul>
         @foreach ($errors->all() as $error)
           <li>{{ $error }}</li>
         @endforeach
      </ul>
    </div>
@endif

@session('success')
    <div class="alert alert-success" role="alert"> 
        {!! $value !!}
    </div>
@endsession

@if(session('error'))
    <div class="alert alert-danger">
        {!! session('error') !!}
    </div>
@endif