@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('assets/js/show-password.js')}}"></script>
@endpush

@section('styles')
<style>
.select2-container {
   z-index: 0 !important; /* Below Choices.js but above other elements */
}
</style>
@endsection

@section('content')
<div class="card custom-card">
   <div class="card-body">
      <form method="POST" action="{{ route('clients.store') }}" class="row g-3 mt-0 needs-validation" novalidate>
         @csrf
         <div class="col-md-6">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}"
            aria-label="{{__('app.name')}}" value="{{ old('name') }}"  name="name" required>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.email')}}</label>
            <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ old('email') }}" name="email" required>
         </div>
         <div class="col-md-6">
            <div class="position-relative">
               <label class="form-label">{{__('app.password')}}</label>
               <input id="password"  type="password" class="form-control" placeholder="{{__('app.password')}}" name="password" required>
               <a href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
         </div>
         <div class="col-md-6">
            <div class="position-relative">
               <label class="form-label">{{__('app.confirm_password')}}</label>
               <input id="confirm-password" type="password" class="form-control" placeholder="{{__('app.confirm_password')}}" name="confirm-password" required>
               <a href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('confirm-password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
            </div>
         </div>
         <div class="col-6">
            <label class="form-label">{{__('app.address')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.address')}}" name="address"  value="{{ old('address') }}">
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.phone')}}</label>
            <input type="text" class="form-control" name="phone"  value="{{ old('phone') }}">
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.timezone')}}</label>
            <select name="timezone" class="single-select form-select" required>
               <option value="">{{__('app.select_timezone')}}</option>
               @foreach(\App\Http\Helper\Helper::timeZones() as $key => $timezone)
               <option value="{{ $key }}" {{ old('timezone') == $key ? 'selected' : '' }}>{{ $timezone }}</option>
               @endforeach
            </select>
         </div>         
         <div class="col-md-6">
            <label class="form-label">{{__('app.status')}}</label>
            <select class="form-select form-select-lg" name="is_active">
               <option value="1">{{__('app.active')}}</option>
               <option value="0">{{__('app.in_active')}}</option>
            </select>
         </div> 
         <div class="col-md-6">
            <label class="form-label">{{__('app.role')}}
               <a href="{{route('roles.create')}}"><i class="bi bi-plus-circle-fill text-primary"></i></a>
            </label>
            <select name="roles" class="form-select form-select-lg" required>
               <option value="">{{__('app.select_role')}}</option>
               @foreach ($roles as $role)
               <option value="{{ $role->name }}" {{ old('roles') == $role->name ? 'selected' : '' }}>
                  {{ $role->display_name }}
               </option>
               @endforeach
            </select>
         </div>
         <div class="col-md-6">
            <label class="form-label">{{__('app.packages')}}
               <a href="{{route('roles.create')}}"><i class="bi bi-plus-circle-fill text-primary"></i></a>
            </label>
            <select name="package_id" class="form-select form-select-lg" required>
               <option value="">{{__('app.select_package')}}</option>
               @foreach ($packages as $package)
               <option value="{{ $package->id }}" {{ old('packages') == $package->name ? 'selected' : '' }}>
                  {{ $package->name }}
               </option>
               @endforeach
            </select>
         </div>        
         <div class="col-12">
            <button type="submit" class="btn btn-primary btn-loading"><i class=""></i> {{__('app.create')}}</button>
            <a href="{{route('users.index')}}">
             <button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
           </a>
         </div>
      </form>
   </div>
</div>
@endsection
