@extends('layouts.app')
@section('title', $page_title)

@section('styles')

@endsection

@push('scripts')
<script src="{{asset('components/jquery-repeater/jquery.repeater.min.js')}}"></script>
<script src="{{asset('assets/js/app.js')}}"></script>
<script type="text/javascript">
$(function() {
	'use strict';
	$('.repeater-contact').repeater({
		show: function () {
			$(this).slideDown();
		},
		hide: function (deleteElement) {
			if(confirm("{{ __('app.msg_delete_repeater_element') }}")) {
				$(this).slideUp(deleteElement);
			}
		},
		isFirstItemUndeletable: true
	});
	$(".modal").on("hidden.bs.modal", function() {
		document.getElementById("shortcode").select();
		document.execCommand("copy");
		$('.btn-primary').focus();
	});
});
</script>
@endpush

@section('content')
<div class="card custom-card">
	<div class="card-body">
		<button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('shortcodes') }}');">{{ __('app.shortcodes') }}</button> {!! __('app.mail_headers_heading') !!}
		<form method="post" action="{{route('broadcast.mail.headers')}}" class="form-horizontal" id="frm-mail-headers">
			@csrf
			@method('PUT')
			<div class="box-body">
				<div class="row box-body mt-3">
					<label class="col-md-4 form-label">{{ __('app.header_name') }}</label>
					<label class="col-md-1 control-label">:</label>
					<label class="col-md-4 form-label">{{ __('app.header_value') }}</label>
				</div>
				<div class="box-body repeater-contact">
					<div data-repeater-list="mail_headers">
						@if(!empty($mail_headers))
						@foreach($mail_headers as $key => $value)
						<div data-repeater-item class="row mt-3">
							<div class="col-md-4">
								<input type="text" class="form-control" name="key" value="{{ \App\Http\Helper\Helper::decodeString($key) }}">
							</div>
							<label class="col-md-1 control-label">:</label>
							<div class="col-md-4">
								<input type="text" class="form-control" name="value" value="{{ \App\Http\Helper\Helper::decodeString($value) }}">
							</div>
							<div class="col-md-3">
								<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
							</div>
						</div>
						@endforeach
						@else
						<div data-repeater-item class="row mt-3">
							<div class="col-md-4">
								<input type="text" class="form-control" name="key" value="">
							</div>
							<label class="col-md-1 control-label">:</label>
							<div class="col-md-4">
								<input type="text" class="form-control" name="value" value="">
							</div>
							<div class="col-md-3">
								<input data-repeater-delete type="button" class="btn btn-primary" value="Delete"/>
							</div>
						</div>
						@endif
					</div>
					<div class="col-12 mt-2">
						<input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
					</div>
				</div>

				<div class="col-12 mt-5">
					<button type="submit" name="save"class="btn btn-primary btn-loading"><i class=""></i> {{__('app.save')}}</button>
					<a href="{{route('contacts.index')}}">
						<button type="button" class="btn btn-danger btn-loading"><i class=""></i> {{__('app.exit')}}</button>
					</a>
				</div>
			</div>
		</form>
	</div>
</div>
@endsection
