<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('global_bounces', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('stat_id')->index();
            $table->unsignedBigInteger('schedule_campaign_stat_log_id')->index();
            $table->enum('section', ['Campaign', 'Drip', 'AutoFollowup', 'SplitTest', 'Add', 'Other'])->default('Campaign');
            $table->string('email')->nullable()->index();
            $table->enum('type', ['Soft', 'Hard'])->default('Soft')->index();
            $table->string('code')->nullable();
            $table->json('detail')->nullable();
            $table->timestamp('created_at')->useCurrent();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('global_bounces');
    }
};
