<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ScheduleCampaign extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'list_ids', 'sending_server_ids', 'schedule_campaign_name', 'email_subject', 'content', 'from_detail', 'from_detail_custom', 'send_datetime', 'threads', 'total_threads', 'total', 'sending_speed', 'app_id', 'user_id', 'scheduled', 'thread_no', 'status', 'send'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('schedule_campaigns.app_id', \Auth::user()->app_id);
    }

    // Get runninc Campaigns
    public static function getRunningCampaing()
    {
        return ScheduleCampaign::whereIn('status', ['Preparing', 'Running', 'Scheduled', 'RunningLimit', 'Resume'])
            ->app()
            ->count();
    }
}
