<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailsPage extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'email_subject', 'slug', 'type', 'content', 'user_id', 'app_id'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }
}
