<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\Import;
use App\Models\Suppression;
use App\Http\Helper\Helper;
use League\Csv\Reader;

class SuppressionImport implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $id, $user_id;
    public $tries = 3;

    /**
     * Create a new job instance.
     */
    public function __construct($id, $user_id)
    {
        $this->id = $id;
        $this->user_id = $user_id;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $import = Import::whereId($this->id)->whereProcessed(0)->first();
        if(!$import) exit;

        $attributes = json_decode($import->attributes);
        
        // get mapped fields 
        $mapping_fields = $attributes->mapping_fields;

        $input['user_id'] = $import->user_id;
        $input['app_id'] = $import->app_id;
        $input['group_id'] = $attributes->group_id;

        // Get total records
        $total_records = Helper::getCsvCount($import->file);

        // Read file from path
        $reader = Reader::createFromPath($import->file, 'r');
        $records = $reader->getRecords();

        $processed = 0;
        foreach ($records as $offset => $record) {
            // Retrieve the email data as mapped. It will always be at index 0 since only one field is mapped.
            $input['email'] = $record[$mapping_fields[0]];

            try {
                if(!Suppression::whereEmail($input['email'])->whereGroupId($input['group_id'])->exists())
                    Suppression::create($input);
            } catch(Exception $e) {}

            Import::whereId($this->id)->increment('processed');
        }

        // unlink file after import
        try {
            unlink($import->file);
        } catch(\Exception $e) {
            \Log::error("job:suppression-import => ".$e->getMessage());
        }

        // save notification for user to inform and download
        $notification_name = __('app.suppression_list'). "  "  . __('app.msg_import_successfully');
        $attributes = [
          'file' => $import->file
        ];
        $notification_attributes = json_encode($attributes);
        $notification = [
          'name' => $notification_name,
          'type' => 'import',
          'attributes' => $notification_attributes,
          'app_id' => $import->app_id,
          'user_id' => $this->user_id
        ];
        \App\Models\Notification::create($notification);
    }
}
