<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateBounceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // Update this if authorization logic is required
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $bounce = $this->route('bounce');
        return [
            'email' => 'required|email|unique:bounces,email' . ($bounce ? ',' . $bounce->id : ''),
            'host' => 'required',
            'username' => 'required',
            'password' => 'required',
            'port' => 'required|integer'
        ];
    }
}
