<?php

namespace App\Http\Middleware;

use Auth;
use App;
use Closure;
use App\Models\User;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetLocal
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $language = !empty(Auth::user()->language) ? Auth::user()->language : 'en';
        App::setLocale($language);
        return $next($request);
    }
}
