<?php

namespace App\Http\Middleware;

use Closure;

class APIstatus
{
  public function handle($request, Closure $next)
  {
    $api_token = str_replace('Bearer ', '', $request->header('authorization'));
    
    // API Token can by passed via param
    if(empty($api_token))
      $api_token = $request->api_token;

    $api_enabled = \App\Models\User::whereApiToken($api_token)->value('api_enabled');
    if(!$api_enabled) {
      return response()->json(['response' => __('app.api_disabled')], 403);
    }
    return $next($request);
  }
}