<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\View\View;
use Spatie\Activitylog\Models\Activity;
use App\Http\Helper\Helper;
use Auth;

class MiscellaneousController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function activityLogs(Request $request): View
    {
        Helper::checkPermissions('activity_logs');
        $page = 'miscellaneous_activity_logs';
        $page_title = __('app.activity_logs');
        $breadcrumbs = [
            __('app.miscellaneous') => '#',
            __('app.activity_logs') => route('activity.logs')
        ];  
        return view('miscellaneous.activity_logs',compact('page', 'page_title', 'breadcrumbs'));
    }

    /**
    * Retrun JSON datatable data
    */
    public function getActivityLogs(Request $request): Void
    {
        $result = Activity::where('properties->app_id', Auth::user()->app_id)
          ->where('id', '<>', 1) // avoid to get superadmin as came with installation
          ->with('causer'); 

        $columns = ['id', 'id', 'log_name', 'description', 'created_at'];

        $data = Helper::dataFilters($request, $result, $columns);

        $result = $data['result'];
        $activity_logs = $result->get();

        $data =  Helper::datatableTotals($data['total']);

        foreach($activity_logs as $log) {
            $name = ucfirst($log->log_name);
            if($log->log_name == 'delete')
                $name = "<span class='badge bg-danger-gradient'>".$name."</span>";
            elseif($log->log_name == 'copy')
                $name = "<span class='badge bg-warning-gradient'>".$name."</span>";
            elseif($log->log_name == 'update')
                $name = "<span class='badge bg-info-gradient'>".$name."</span>";
            elseif($log->log_name == 'create')
                $name = "<span class='badge bg-success-gradient'>".$name."</span>";
            elseif($log->log_name == 'schedule')
                $name = "<span class='badge bg-warning-gradient'>".$name."</span>";
            else
                $name = "<span class='badge bg-purple-gradient'>".$name."</span>";

          $checkbox = "<input type=\"checkbox\" value=\"{$log->id}\" class=\"form-check-input\">";

          $data['data'][] = [
            "DT_RowId" => "row_{$log->id}",
            $log->id,
            $log->causer['name'] ?? '---',
            $name,
            $log->description ?? '---',
            Helper::datetimeDisplay($log->created_at)
          ];
        }
        echo json_encode($data);
    }

    /**
    * Get Error Logs
    */
    public function errorLogs(): View
    { 
        Helper::checkPermissions('error_logs');
        $page = 'miscellaneous_error_logs';
        $page_title = __('app.error_logs');
        $breadcrumbs = [
            __('app.miscellaneous') => '#',
            __('app.error_logs') => route('error.logs')
        ]; 
        return view('miscellaneous.error_logs')->with(compact('page', 'page_title', 'breadcrumbs'));
    }

    /**
    * Get PHP Info
    */
    public function phpinfo(): View
    { 
        Helper::checkPermissions('php_info');
        $page = 'miscellaneous_php_info';
        $page_title = __('app.php_info');
        $breadcrumbs = [
            __('app.miscellaneous') => '#',
            __('app.php_info') => route('php.info')
        ]; 
        return view('miscellaneous.phpinfo')->with(compact('page', 'page_title', 'breadcrumbs'));
    }
}
