<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Webklex\PHPIMAP\ClientManager;
use App\Models\Bounce;
use App\Models\Contact;
use App\Http\Helper\Helper;

class ProcessBounces extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'process:bounces';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process application bounces';

    public $code = '5.1.1';
    public $type = 'Hard';
    public $short_detail = null;
    public $message_id = null;
    public $to = null;
    public $full_detail = null;
    public $app_id = 1;

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Proces system bounces
        try {
          $this->systemBounces();
        } catch (\Exception $e) {
          $error = $e->getMessage();
          \Log::error("process:bounces => ".$error);
        }
    }


    private function systemBounces()
    {
        $bounces = Bounce::active()->get();

        foreach($bounces as $bounce) {
          $validate_cert = $bounce->validate_cert == 'Yes' ? true : false;
          $password = !empty($bounce->password) ? \Crypt::decrypt($bounce->password) : '';

          // Create a new ClientManager instance
            $clientManager = new ClientManager();

            // Set up the client configuration
            $client = $clientManager->make([
                'host'          => $bounce->host,
                'port'          => $bounce->port,
                'encryption'    => $bounce->encryption,
                'validate_cert' => $validate_cert,
                'username'      => $bounce->username,
                'password'      => $password,
                'protocol'      => $bounce->method
            ]);

          try {
            //Connect to the IMAP Server
            $client->connect();
            //Get all Mailboxes
            try {
              // false due to get office 365 emails
              $aFolder = $client->getFolders(false);
            } catch (\Exception $e) {
              $error = $e->getMessage();
            }
            //Loop through every Mailbox
            foreach($aFolder as $oFolder){
              //Get 1 day old Messages of the current Mailbox $oFolder with limit 10 of page-no upto 50 pages
              for($page=1; $page<50; $page++) {
               $aMessage = $oFolder->query()->since(now()->subDays(1))->limit(10, $page)->get();
                foreach($aMessage as $oMessage) {
                  $aAttachment = $oMessage->getAttachments();
                  $aAttachment->each(function ($oAttachment) use ($oMessage) {
                  $content =  $oAttachment->getContent();
                    // Get bounce type and short detail
                    $code = Helper::extractString($content, 'Status:', "\n");

                    // Avoid to save the data for X-OutGoing-Spam-Status: No, score=-1.0
                    if(stripos($code, 'score') === false) {
                      if(!empty($code)) {
                        $bounce_code_detail = Helper::bouceCodes($code);
                        if(!empty($bounce_code_detail)) {
                          $this->type = $bounce_code_detail['type'];
                          $this->short_detail = $bounce_code_detail['description'];
                          $this->code = $code;
                        }
                      }
                      //$this->to = str_replace('rfc822;', '', Helper::extractString($content, 'Final-Recipient:', "\n"));
                      $this->full_detail = !empty($oMessage->getTextBody()) ? $oMessage->getTextBody() : $oMessage->getHTMLBody(true);
                    }

                    if(strpos($content, 'Message-ID:') !== false) {
                      $this->message_id = Helper::extractString($content, 'Message-ID:', "\n");
                      try {
                        // To process only campaign bounces; RZ_type can be other like split-test, drip etc
                        $RZ_type = Helper::extractString($content, 'RZ-Type-ID:', "\n");
                      } catch(\Exception $e) {
                        $RZ_type = 'campaign';
                      }

                      list($app_id, $stat_log_id, $stat_id, $to_email, $section) = $this->toEamil_Section($RZ_type);

                      Helper::saveBounce($stat_id, $to_email, $stat_log_id, $section, $this->code, $this->type, $this->short_detail, $this->full_detail, $app_id);
                      // update contact set bounced
                      Contact::whereEmail($to_email)->update([
                        'is_bounced' => true
                      ]);
                    }
                  });

                  if($bounce->delete_after_processing == 'Yes') {
                    // Delete the message afer process
                    $oMessage->delete();
                  }
                }
              }     
            }
          } catch (\Exception $e) {
            $error = $e->getMessage();
            \Log::error("process:bounces => ".$error);
          }
        }
    }

    private function toEamil_Section($RZ_type)
    {
        try {
          $stat_log_id = explode('-', $RZ_type)[1];
        } catch(\Exception $e) {
          $stat_log_id = 0;
        }

        try {
          $app_id = explode('-', $RZ_type)[2];
        } catch(\Exception $e) {
          $app_id = $this->app_id;
        }

        $section = 'Campaign';
        $to_email = null;
        $stat_id = 0;

        if($stat_log_id) {
          if(stripos($RZ_type, 'campaign') !== false) {
            \App\Models\ScheduleCampaignStatLog::whereId($stat_log_id)->update(['status' => 'Bounced']);
            $stat_data = \App\Models\ScheduleCampaignStatLog::whereId($stat_log_id)->select('email', 'schedule_campaign_stat_id')->first();
            $stat_id = $stat_data->schedule_campaign_stat_id;
            $to_email = $stat_data->email;
          }
        }

        return [
          $app_id,
          $stat_log_id,
          $stat_id,
          $to_email,
          $section
        ];
    }
}
