<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class Cleaner extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'relayzo:cleaner';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean DB and extra files';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Clean unnecessary files
        try {
          $this->cleanFiles();
        } catch(\Exception $e) {
          echo $e->getMessage();
          \Log::error('relayzo:cleaner:2 => '.$e->getMessage());
        }
    }

      /**
       * Clean unnecessary files
      */
      protected function cleanFiles()
      {
        // Remove completed campaign files
        $schedules = \App\Models\ScheduleCampaign::whereStatus('Completed')
          ->select('id', 'user_id')
          ->orderBy('id', 'desc')
          ->get();

        if(count($schedules) > 0) {
          foreach($schedules as $schedule) {
            $path_schedule_campaign = str_replace('[user-id]', $schedule->user_id, config('custom.path_schedule_campaign'));
            $dir = $path_schedule_campaign.$schedule->id.DIRECTORY_SEPARATOR;
            if(is_dir($dir)) {
              try {
                $files = scandir($dir);
              } catch (\Exception $e) {
                \Log::error('relayzo:cleaner:3 => '.$e->getMessage());
              }

              try {
                foreach($files as $file_no) {
                  $file = $dir.$file_no;
                  try {
                    unlink($file);
                  } catch (\Exception $e) {
                    \Log::error('relayzo:cleaner:4 => '.$e->getMessage());
                  }
                }
                rmdir($dir);
              } catch (\Exception $e) {
                \Log::error('relayzo:cleaner:5 => '.$e->getMessage());
              }
            }
          }
        }
        

        // If campaing is deleted
        $users = \App\Models\User::all();

        foreach($users as $user) {
          $path_schedule_campaign = str_replace('[user-id]', $user->id, config('custom.path_schedule_campaign'));
          try {
            $dirs = scandir($path_schedule_campaign);
          } catch (\Exception $e) {
            // nothing to write otherwise lot of unnecessary data writes
          }

          if(!empty($dirs)) {
            foreach($dirs as $dir_id) {
              // no need to delete other director files
              if(\App\Models\ScheduleCampaign::whereId($dir_id)->exists()) continue;

              if($dir_id != '.' && $dir_id != '..') {
                $dir = $path_schedule_campaign.$dir_id.DIRECTORY_SEPARATOR;
                if(is_dir($dir)) {
                  try {
                    $files = scandir($dir);
                  } catch (\Exception $e) {
                    \Log::error('relayzo:cleaner:6 => '.$e->getMessage());
                  }

                  try {
                    foreach($files as $file_no) {
                      $file = $dir.$file_no;
                      try {
                        unlink($file);
                      } catch (\Exception $e) {
                        \Log::error('relayzo:cleaner:7 => '.$e->getMessage());
                      }
                    }
                    rmdir($dir);
                  } catch (\Exception $e) {
                  \Log::error('relayzo:cleaner:8 => '.$e->getMessage());
                  }
                }
              }
            }
          }
        }
      }
}
