<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class UniqueCustomField implements ValidationRule
{
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // Fetch the current user's app_id (or pass it via constructor if needed)
        $appId = \Auth::user()->app_id; 
        
        // Check if a custom field with the same app_id and name exists
        $exists = \App\Models\CustomField::where('app_id', $appId)
                             ->where('name', $value)
                             ->exists();

        if ($exists) {
            // Call the $fail closure to report the validation failure
            $fail(__('validation.unique'));
        }
    }
}
