<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Http\Helper\Helper;

class CustomResetPassword extends Notification
{
    use Queueable;
    private $token;

    /**
     * Create a new notification instance.
     */
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
          $settings = \DB::table('settings')->whereId(config('custom.app_id'))->first();
          $connection = Helper::configureSendingNode($settings->sending_type, $settings->sending_attributes);

          // If no connection available then should be send as php mail function
          if(!$connection['success']) {
            $connection = Helper::configureSendingNode('php_mail', $settings->sending_attributes);
          }

          if($connection['success']) {
            $email_content = $this->forgotEmailcontent($notifiable, $settings);

            if(in_array($settings->sending_type, Helper::sendingServersFramworkSuported())) {
              $message = new \Symfony\Component\Mime\Email();
              $message->from(new \Symfony\Component\Mime\Address($settings->from_email, $settings->from_name));

               // get sending domain from email
               $sending_domain = Helper::getSendingDomainFromEmail($settings->from_email);

              // set headers
              $headers= $message->getHeaders();
              $headers->addIdHeader('Message-ID', Helper::getCustomMessageID($sending_domain->protocol.$sending_domain->domain));
              $headers->addTextHeader('List-Unsubscribe', "<mail-to: {$settings->from_email}?subject=unsubscribe>");

              $message->to($notifiable->email);
              $message->subject("{$settings->app_name} - Reset your password");
              $message->html($email_content);
              try {
                $connection['transport']->send($message);

               // session()->flash('msg', __('app.msg_password_reset_email_success'));
             //   session()->flash('alert-class', 'text-success');
              } catch(\Exception $e) {
              //  session()->flash('msg', $e->getMessage());
              //  session()->flash('alert-class', 'text-danger');
              }
            } elseif($settings->sending_type == 'sendgrid_api') {
              $message = new \SendGrid\Mail\Mail();
              $message->addTo($notifiable->email, $notifiable->name);
              $message->setFrom($settings->from_email, $settings->app_name);
              $message->setSubject("{$settings->app_name} - Reset your password");
              $message->addContent("text/html", $email_content);
              $sendgrid = new \SendGrid(\Crypt::decrypt(json_decode($settings->sending_attributes)->api_key));
              try {
                $response = $sendgrid->send($message);
                // status start with 2 consider as sent
                if(substr($response->statusCode(), 1) == 2) {
                //  session()->flash('msg', __('app.msg_password_reset_email_success'));
                //  session()->flash('alert-class', 'text-success');
                } else {
                //  session()->flash('msg', json_decode($response->body())->errors[0]->message);
                //  session()->flash('alert-class', 'text-danger');
                }
              } catch(\Exception $e) {
               // echo $e->getMessage();
                $status = 'Failed';
              }
            }
          } else {
            /*session()->flash('msg', __($connection['msg']));
            session()->flash('alert-class', 'text-danger');*/
          }
          return new MailMessage();
    }

        /**
     * Return content that will be send for forgot password
    */
    public function forgotEmailcontent($notifiable, $settings)
    {
      return "<!DOCTYPE html><html>
<head>
  <title>{$settings->app_name}</title>
</head>
<body>
  Dear {$notifiable->name}, <br/>
  <h3>Can't remember your password?</h3>
  <p>
    Don't worry, it may happens. We can help.
  </p>
  <p>
    <strong>Email:</strong> {$notifiable->email}
  </p>
  <p>
    Use this link to reset your password:<a href='{$settings->app_url}/password/reset/{$this->token}'> {$settings->app_url}/password/reset/{$this->token} </a>
  </p>
  <br/>
  Thank you,
  <br/>
  {$settings->app_name}
</body>
</html>";
    }
}
