<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TriggerScheduleStat extends Model
{
    use HasFactory;
    protected $fillable = ['trigger_id', 'trigger_name', 'email_sujbect', 'content', 'schedule_by', 'app_id', 'user_id'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }


    /**
    * Return query that helps to find opens for a scheduled
    * @param int trigger_schedule_stat_id
    * @param string all / unique
    */
    public static function statLogOpens($trigger_schedule_stat_id, $filter='all')
    {
        $query = TriggerScheduleStat::join('trigger_schedule_stat_logs', 'trigger_schedule_stats.id', '=', 'trigger_schedule_stat_logs.trigger_schedule_stat_id')
          ->join('trigger_schedule_stat_log_opens', 'trigger_schedule_stat_logs.id', '=', 'trigger_schedule_stat_log_opens.trigger_schedule_stat_log_id')
          ->where('trigger_schedule_stats.id', $trigger_schedule_stat_id);

        if($filter == 'unique') {
          $query = $query->select('trigger_schedule_stat_log_opens.trigger_schedule_stat_log_id')
            ->groupBy('trigger_schedule_stat_log_opens.trigger_schedule_stat_log_id');
        } else {
          $query = $query->select('trigger_schedule_stats.id as id', 'trigger_schedule_stats.trigger_name as name', 'trigger_schedule_stat_logs.id as stat_log_id', 'trigger_schedule_stat_logs.message_id', 'trigger_schedule_stat_logs.email', 'trigger_schedule_stat_logs.list', 'trigger_schedule_stat_logs.sending_server', 'trigger_schedule_stat_logs.status', 'trigger_schedule_stat_log_opens.*');
        }
        return $query;
    }

    /**
    * Return query that helps to find clicks for a scheduled
    * @param int trigger_schedule_stat_id
    * @param string all / unique
    */
    public static function statLogClicks($trigger_schedule_stat_id, $filter='all')
    {
    $query = TriggerScheduleStat::join('trigger_schedule_stat_logs', 'trigger_schedule_stats.id', '=', 'trigger_schedule_stat_logs.trigger_schedule_stat_id')
      ->join('trigger_schedule_stat_log_clicks', 'trigger_schedule_stat_logs.id', '=', 'trigger_schedule_stat_log_clicks.trigger_schedule_stat_log_id')
      ->where('trigger_schedule_stats.id', $trigger_schedule_stat_id);

    if($filter == 'unique') {
      $query = $query->select('trigger_schedule_stat_log_clicks.trigger_schedule_stat_log_id')
        ->groupBy('trigger_schedule_stat_log_clicks.trigger_schedule_stat_log_id');
    } else {
      $query = $query->select('trigger_schedule_stats.id as id', 'trigger_schedule_stats.trigger_name as name', 'trigger_schedule_stat_logs.id as stat_log_id', 'trigger_schedule_stat_logs.message_id', 'trigger_schedule_stat_logs.email', 'trigger_schedule_stat_logs.list', 'trigger_schedule_stat_logs.status', 'trigger_schedule_stat_log_clicks.*');
    }
    return $query;
    }

    /**
    * Return query that helps to find bounces for a scheduled
    * @param int trigger_schedule_stat_id
    */
    public static function statLogBounces($trigger_schedule_stat_id)
    {
    $query = TriggerScheduleStat::join('trigger_schedule_stat_logs', 'trigger_schedule_stats.id', '=', 'trigger_schedule_stat_logs.trigger_schedule_stat_id')
      ->join('global_bounces', 'trigger_schedule_stat_logs.id', '=', 'global_bounces.schedule_campaign_stat_log_id')
      ->where('global_bounces.stat_id', $trigger_schedule_stat_id)
      ->where('global_bounces.section', 'Trigger')
      ->where('trigger_schedule_stats.id', $trigger_schedule_stat_id)
      ->where('trigger_schedule_stats.app_id', \Auth::user()->app_id)
      ->select('trigger_schedule_stats.id as id', 'trigger_schedule_stats.trigger_name as name', 'trigger_schedule_stat_logs.id as stat_log_id', 'trigger_schedule_stat_logs.message_id', 'trigger_schedule_stat_logs.email', 'trigger_schedule_stat_logs.list', 'trigger_schedule_stat_logs.status', 'global_bounces.*');
    return $query;
    }

    /**
    * Return query that helps to find spam for a scheduled
    * @param int trigger_schedule_stat_id
    */
    public static function statLogSpam($trigger_schedule_stat_id)
    {
    $query = TriggerScheduleStat::join('trigger_schedule_stat_logs', 'trigger_schedule_stats.id', '=', 'trigger_schedule_stat_logs.trigger_schedule_stat_id')
      ->join('global_spams', 'trigger_schedule_stat_logs.id', '=', 'global_spams.schedule_campaign_stat_log_id')
      ->where('trigger_schedule_stats.id', $trigger_schedule_stat_id)
      ->where('trigger_schedule_stats.app_id', \Auth::user()->app_id)
      ->where('global_spams.section', 'Trigger')
      ->select('trigger_schedule_stats.id as id', 'trigger_schedule_stats.trigger_name as name', 'trigger_schedule_stat_logs.id as stat_log_id', 'trigger_schedule_stat_logs.message_id', 'trigger_schedule_stat_logs.email', 'trigger_schedule_stat_logs.list', 'trigger_schedule_stat_logs.status', 'global_spams.*');;
    return $query;
    }

    /**
    * Return query that helps to find unique data like lists, boradcasts, and sending_serers for schedule
    * @param int trigger_schedule_stat_id
    * @param strin list, sending_server
    */
    public static function statLogData($trigger_schedule_stat_id, $value='list')
    {
    $query = TriggerScheduleStat::join('trigger_schedule_stat_logs', 'trigger_schedule_stats.id', '=', 'trigger_schedule_stat_logs.trigger_schedule_stat_id')
      ->where('trigger_schedule_stats.id', $trigger_schedule_stat_id)
      ->where('trigger_schedule_stats.app_id', \Auth::user()->app_id)
      ->select("trigger_schedule_stat_logs.{$value}")
      ->groupBy("trigger_schedule_stat_logs.{$value}")
      ->select("trigger_schedule_stat_logs.{$value}", \DB::raw('count(*) as total'));
    return $query;
    }

    /**
    * Return query that helps to find unique data like lists, boradcasts, and sending_serers for schedule
    * @param int trigger_schedule_stat_id
    * @param strin list, sending_server
    */
    public static function getUniqueCountries($trigger_schedule_stat_id=null, $table='opens')
    {
    $table = $table == 'opens' ? 'trigger_schedule_stat_log_opens' : 'trigger_schedule_stat_log_clicks';

    $query = TriggerScheduleStat::join('trigger_schedule_stat_logs', 'trigger_schedule_stats.id', '=', 'trigger_schedule_stat_logs.trigger_schedule_stat_id')
      ->join($table, 'trigger_schedule_stat_logs.id', '=', "$table.trigger_schedule_stat_log_id");
      
    if(!empty($trigger_schedule_stat_id)) {
      $query = $query->where('trigger_schedule_stats.id', $trigger_schedule_stat_id);
    }

    $query = $query->select(\DB::raw('count(country_code) as cnt, country_code'))
      ->groupBy("$table.country_code");

    return $query;
    }
}
