<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trigger extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'detail', 'is_active', 'based_on', 'action', 'sending_server_ids', 'attributes', 'in_progress', 'execution_datetime', 'app_id', 'user_id'];

    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }

    public function triggerScheduleStat()
    {
        return $this->hasOne('App\Models\TriggerScheduleStat', 'trigger_id');
    }
}
